package mutantcreatures;

import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.World;

public class MCAIAttackOnCollide extends EntityAIBase {
	
	private int maxAttackTick;
	private float yawSpeed, pitchSpeed;
	
	World worldObj;
    EntityLiving attacker;
	EntityLiving entityTarget;
    private int attackTick;
    float field_75440_e;
    boolean field_75437_f;
    PathEntity entityPathEntity;
    Class classTarget;
    private int field_75445_i;

	public MCAIAttackOnCollide setMaxAttackTick(int tick) {
		maxAttackTick = tick;
		return this;
	}
	
	public int getAttackTick() {
		return attackTick;
	}
	
	public void resetAttackTick() {
		attackTick = maxAttackTick;
	}
	
	public MCAIAttackOnCollide setTurnSpeed(float yaw, float pitch) {
		yawSpeed = yaw;
		pitchSpeed = pitch;
		return this;
	}
	
    public MCAIAttackOnCollide(EntityLiving par1EntityLiving, Class par2Class, float par3, boolean par4)
    {
        this(par1EntityLiving, par3, par4);
        this.classTarget = par2Class;
    }

    public MCAIAttackOnCollide(EntityLiving par1EntityLiving, float par2, boolean par3)
    {
		maxAttackTick = 20;
		yawSpeed = 30F;
		pitchSpeed = 30F;
		
        this.attackTick = 0;
        this.attacker = par1EntityLiving;
        this.worldObj = par1EntityLiving.worldObj;
        this.field_75440_e = par2;
        this.field_75437_f = par3;
        this.setMutexBits(3);
    }

    public boolean shouldExecute()
    {
        EntityLiving var1 = this.attacker.getAttackTarget();

        if (var1 == null)
        {
            return false;
        }
        else if (this.classTarget != null && !this.classTarget.isAssignableFrom(var1.getClass()))
        {
            return false;
        }
        else
        {
            this.entityTarget = var1;
            this.entityPathEntity = this.attacker.getNavigator().getPathToEntityLiving(this.entityTarget);
            return this.entityPathEntity != null;
        }
    }

    public boolean continueExecuting()
    {
        EntityLiving var1 = this.attacker.getAttackTarget();
        return var1 == null ? false : (!this.entityTarget.isEntityAlive() ? false : (!this.field_75437_f ? !this.attacker.getNavigator().noPath() : this.attacker.isWithinHomeDistance(MathHelper.floor_double(this.entityTarget.posX), MathHelper.floor_double(this.entityTarget.posY), MathHelper.floor_double(this.entityTarget.posZ))));
    }

    public void startExecuting()
    {
        this.attacker.getNavigator().setPath(this.entityPathEntity, this.field_75440_e);
        this.field_75445_i = 0;
    }

    public void resetTask()
    {
        this.entityTarget = null;
        this.attacker.getNavigator().clearPathEntity();
    }

    public void updateTask()
    {
        this.attacker.getLookHelper().setLookPositionWithEntity(this.entityTarget, yawSpeed, pitchSpeed);

        if ((this.field_75437_f || this.attacker.getEntitySenses().canSee(this.entityTarget)) && --this.field_75445_i <= 0)
        {
            this.field_75445_i = 4 + this.attacker.getRNG().nextInt(7);
            this.attacker.getNavigator().tryMoveToEntityLiving(this.entityTarget, this.field_75440_e);
        }

        this.attackTick = Math.max(this.attackTick - 1, 0);
        double var1 = (double)(this.attacker.width * 2.0F * this.attacker.width * 2.0F);

        if (this.attacker.getDistanceSq(this.entityTarget.posX, this.entityTarget.boundingBox.minY, this.entityTarget.posZ) <= var1)
        {
            if (this.attackTick <= 0)
            {
                resetAttackTick();
                this.attacker.attackEntityAsMob(this.entityTarget);
            }
        }
    }
}