/*
 * Decompiled with CFR 0.152.
 */
package basiccomponents.common.tileentity;

import basiccomponents.common.BasicComponents;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.electricity.ElectricalEventHandler;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.IElectricityNetwork;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.ElectricityHandler;
import universalelectricity.prefab.tile.TileEntityElectrical;

public class TileEntityCoalGenerator
extends TileEntityElectrical
implements IElectrical,
IInventory,
ISidedInventory,
IPacketReceiver {
    public static final int MAX_GENERATE_WATTS = 10000;
    public static final int MIN_GENERATE_WATTS = 100;
    private static final float BASE_ACCELERATION = 0.3f;
    public float prevGenerateWatts;
    public float generateWatts = 0.0f;
    public int itemCookTime = 0;
    private ItemStack[] containingItems = new ItemStack[1];
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();

    public TileEntityCoalGenerator() {
        this.electricityHandler = new ElectricityHandler(this, 10000.0f);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            this.prevGenerateWatts = this.generateWatts;
            ForgeDirection outputDirection = ForgeDirection.getOrientation((int)(this.func_70322_n() - 0 + 2));
            TileEntity outputTile = VectorHelper.getConnectorFromSide(this.field_70331_k, new Vector3(this.field_70329_l, this.field_70330_m, this.field_70327_n), outputDirection);
            IElectricityNetwork network = ElectricalEventHandler.getNetworkFromTileEntity(outputTile, outputDirection);
            if (this.itemCookTime > 0) {
                --this.itemCookTime;
                if (this.getEnergyStored() < this.getMaxEnergyStored()) {
                    this.generateWatts = Math.min(this.generateWatts + Math.min(this.generateWatts * 0.005f + 0.3f, 5.0f), 10000.0f);
                }
            }
            if (this.containingItems[0] != null && this.getEnergyStored() < this.getMaxEnergyStored() && this.containingItems[0].func_77973_b().field_77779_bT == Item.field_77705_m.field_77779_bT && this.itemCookTime <= 0) {
                this.itemCookTime = 320;
                this.func_70298_a(0, 1);
            }
            if (this.getEnergyStored() >= this.getMaxEnergyStored() || this.itemCookTime <= 0) {
                this.generateWatts = Math.max(this.generateWatts - 8.0f, 0.0f);
            }
            if (this.generateWatts > 100.0f) {
                this.electricityHandler.receiveElectricity(ElectricityPack.getFromWatts(this.generateWatts / this.getVoltage(), this.getVoltage()), true);
            }
            if (this.ticks % 3L == 0L) {
                for (EntityPlayer player : this.playersUsing) {
                    PacketDispatcher.sendPacketToPlayer((Packet)this.func_70319_e(), (Player)((Player)player));
                }
            }
            if (this.prevGenerateWatts <= 0.0f && this.generateWatts > 0.0f || this.prevGenerateWatts > 0.0f && this.generateWatts <= 0.0f) {
                PacketManager.sendPacketToClients(this.func_70319_e(), this.field_70331_k);
            }
        }
    }

    public Packet func_70319_e() {
        return PacketManager.getPacket(BasicComponents.CHANNEL, this, new Object[]{Float.valueOf(this.generateWatts), this.itemCookTime});
    }

    @Override
    public void handlePacketData(INetworkManager network, int type, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            if (this.field_70331_k.field_72995_K) {
                this.generateWatts = dataStream.readFloat();
                this.itemCookTime = dataStream.readInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.itemCookTime = par1NBTTagCompound.func_74762_e("itemCookTime");
        this.generateWatts = par1NBTTagCompound.func_74760_g("generateRate");
        NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("itemCookTime", this.itemCookTime);
        par1NBTTagCompound.func_74776_a("generateRate", this.generateWatts);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return LanguageRegistry.instance().getStringLocalization("tile.basiccomponents:bcMachine.0.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return itemstack.field_77993_c == Item.field_77705_m.field_77779_bT;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int j) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int j) {
        return slotID == 0;
    }

    @Override
    public float receiveElectricity(ForgeDirection from, ElectricityPack electricityPack, boolean doReceive) {
        return 0.0f;
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        return 0.0f;
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        return this.generateWatts;
    }
}

