/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import net.minecraft.world.World;

public class SafeTimeTracker {
    private long lastMark = Long.MIN_VALUE;
    private long duration = 0L;
    private boolean marked;

    public boolean markTimeIfDelay(World world, long delay) {
        if (world == null) {
            return false;
        }
        long currentTime = world.func_72820_D();
        if (currentTime < this.lastMark) {
            this.lastMark = currentTime;
            return false;
        }
        if (this.lastMark + delay <= currentTime) {
            this.duration = currentTime - this.lastMark;
            this.lastMark = world.func_72820_D();
            this.marked = true;
            return true;
        }
        return false;
    }

    public long durationOfLastDelay() {
        return this.marked ? this.duration : 0L;
    }

    public void markTime(World world) {
        this.lastMark = world.func_72820_D();
    }
}

