/*
 * Decompiled with CFR 0.152.
 */
package calclavia.lib.flag;

import calclavia.lib.flag.FlagBase;
import calclavia.lib.flag.FlagWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import universalelectricity.core.vector.Vector3;

public class ModFlag
extends FlagBase {
    private final List<FlagWorld> flagWorlds = new ArrayList<FlagWorld>();

    public ModFlag(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            for (NBTTagCompound dimensionCompound : nbt.func_74758_c()) {
                try {
                    int dimensionID = Integer.parseInt(dimensionCompound.func_74740_e().replace("dim_", ""));
                    WorldServer world = DimensionManager.getWorld((int)dimensionID);
                    FlagWorld flagWorld = new FlagWorld((World)world);
                    flagWorld.readFromNBT(dimensionCompound);
                    this.flagWorlds.add(flagWorld);
                }
                catch (Exception e) {
                    System.out.println("Mod Flag: Failed to read dimension data: " + dimensionCompound.func_74740_e());
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            for (FlagWorld worldData : this.flagWorlds) {
                try {
                    nbt.func_74782_a("dim_" + worldData.world.field_73011_w.field_76574_g, (NBTBase)worldData.getNBT());
                }
                catch (Exception e) {
                    System.out.println("Mod Flag: Failed to save world flag data: " + worldData.world);
                    e.printStackTrace();
                }
            }
        }
    }

    public FlagWorld getFlagWorld(World world) {
        FlagWorld worldData = null;
        if (world != null) {
            for (FlagWorld data : this.flagWorlds) {
                if (data.world == null || data.world.field_73011_w == null || data.world.field_73011_w.field_76574_g != world.field_73011_w.field_76574_g) continue;
                worldData = data;
                break;
            }
            if (worldData == null) {
                worldData = new FlagWorld(world);
                this.flagWorlds.add(worldData);
            }
        }
        return worldData;
    }

    public boolean containsValue(World world, String flagName, String checkValue, Vector3 position) {
        return this.getFlagWorld(world).containsValue(flagName, checkValue, position);
    }

    public List<FlagWorld> getFlagWorlds() {
        return this.flagWorlds;
    }
}

