/*
 * Decompiled with CFR 0.152.
 */
package calclavia.lib.gui;

import calclavia.lib.Calclavia;
import calclavia.lib.gui.GuiBase;
import calclavia.lib.gui.GuiSlotType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.ResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import universalelectricity.core.vector.Vector2;
import universalelectricity.prefab.TranslationHelper;
import universalelectricity.prefab.vector.Region2;

public class GuiScreenBase
extends GuiBase {
    private static final int METER_X = 54;
    public static final int METER_HEIGHT = 49;
    public static final int METER_WIDTH = 14;
    public static final int METER_END = 68;
    public String tooltip = "";
    protected HashMap<Region2, String> tooltips = new HashMap();
    protected int containerWidth;
    protected int containerHeight;

    public GuiScreenBase() {
        this.ySize = 217;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY, float var1) {
        for (Map.Entry<Region2, String> entry : this.tooltips.entrySet()) {
            if (!entry.getKey().isIn(new Vector2(mouseX - this.guiLeft, mouseY - this.guiTop))) continue;
            this.tooltip = entry.getValue();
            break;
        }
        if (this.tooltip != null && this.tooltip != "") {
            this.drawTooltip(mouseX - this.guiLeft, mouseY - this.guiTop, Calclavia.splitStringPerWord(this.tooltip, 5).toArray(new String[0]));
        }
        this.tooltip = "";
    }

    @Override
    protected void drawBackgroundLayer(int x, int y, float var1) {
        this.containerWidth = (this.field_73880_f - this.xSize) / 2;
        this.containerHeight = (this.field_73881_g - this.ySize) / 2;
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_EMPTY_FILE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth, this.containerHeight, 0, 0, this.xSize, this.ySize);
    }

    protected void drawBulb(int x, int y, boolean isOn) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_EMPTY_FILE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isOn) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 161, 0, 6, 6);
        } else {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 161, 4, 6, 6);
        }
    }

    protected void drawTextWithTooltip(String textName, String format, int x, int y, int mouseX, int mouseY) {
        this.drawTextWithTooltip(textName, format, x, y, mouseX, mouseY, 0x404040);
    }

    protected void drawTextWithTooltip(String textName, String format, int x, int y, int mouseX, int mouseY, int color) {
        String name = TranslationHelper.getLocal("gui." + textName + ".name");
        String text = format.replaceAll("%1", name);
        this.field_73886_k.func_78276_b(text, x, y, color);
        String tooltip = TranslationHelper.getLocal("gui." + textName + ".tooltip");
        if (tooltip != null && tooltip != "" && this.isPointInRegion(x, y, (int)((double)text.length() * 4.8), 12, mouseX, mouseY)) {
            this.tooltip = tooltip;
        }
    }

    protected boolean isPointInRegion(int par1, int par2, int par3, int par4, int par5, int par6) {
        int k1 = this.guiLeft;
        int l1 = this.guiTop;
        return (par5 -= k1) >= par1 - 1 && par5 < par1 + par3 + 1 && (par6 -= l1) >= par2 - 1 && par6 < par2 + par4 + 1;
    }

    protected void drawTextWithTooltip(String textName, int x, int y, int mouseX, int mouseY) {
        this.drawTextWithTooltip(textName, "%1", x, y, mouseX, mouseY);
    }

    protected void drawSlot(int x, int y, GuiSlotType type, float r, float g, float b) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_EMPTY_FILE);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 0, 18, 18);
        if (type != GuiSlotType.NONE) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 18 * type.ordinal(), 18, 18);
        }
    }

    protected void drawSlot(int x, int y, GuiSlotType type) {
        this.drawSlot(x, y, type, 1.0f, 1.0f, 1.0f);
    }

    protected void drawSlot(int x, int y) {
        this.drawSlot(x, y, GuiSlotType.NONE);
    }

    protected void drawBar(int x, int y, float scale) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_EMPTY_FILE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 18, 0, 22, 15);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 18, 15, 22 - (int)(scale * 22.0f), 15);
        }
    }

    protected void drawForce(int x, int y, float scale) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_EMPTY_FILE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 0, 107, 11);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 11, (int)(scale * 107.0f), 11);
        }
    }

    protected void drawElectricity(int x, int y, float scale) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_EMPTY_FILE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 0, 107, 11);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 22, (int)(scale * 107.0f), 11);
        }
    }

    protected void drawMeter(int x, int y, float scale, FluidStack fluidStack) {
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_EMPTY_FILE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 0, 14, 49);
        this.displayGauge(this.containerWidth + x, this.containerHeight + y, 0, 0, (int)(48.0f * scale), fluidStack);
        this.field_73882_e.field_71446_o.func_110577_a(Calclavia.GUI_EMPTY_FILE);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 98, 14, 49);
    }

    @Override
    public void drawTooltip(int x, int y, String ... toolTips) {
        if (!GuiScreen.func_73877_p()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            if (toolTips != null) {
                int var7;
                int var6;
                int var5 = 0;
                for (var6 = 0; var6 < toolTips.length; ++var6) {
                    var7 = this.field_73886_k.func_78256_a(toolTips[var6]);
                    if (var7 <= var5) continue;
                    var5 = var7;
                }
                var6 = x + 12;
                var7 = y - 12;
                int var9 = 8;
                if (toolTips.length > 1) {
                    var9 += 2 + (toolTips.length - 1) * 10;
                }
                if (this.guiTop + var7 + var9 + 6 > this.field_73881_g) {
                    var7 = this.field_73881_g - var9 - this.guiTop - 6;
                }
                this.field_73735_i = 300.0f;
                int var10 = -267386864;
                this.func_73733_a(var6 - 3, var7 - 4, var6 + var5 + 3, var7 - 3, var10, var10);
                this.func_73733_a(var6 - 3, var7 + var9 + 3, var6 + var5 + 3, var7 + var9 + 4, var10, var10);
                this.func_73733_a(var6 - 3, var7 - 3, var6 + var5 + 3, var7 + var9 + 3, var10, var10);
                this.func_73733_a(var6 - 4, var7 - 3, var6 - 3, var7 + var9 + 3, var10, var10);
                this.func_73733_a(var6 + var5 + 3, var7 - 3, var6 + var5 + 4, var7 + var9 + 3, var10, var10);
                int var11 = 0x505000FF;
                int var12 = (var11 & 0xFEFEFE) >> 1 | var11 & 0xFF000000;
                this.func_73733_a(var6 - 3, var7 - 3 + 1, var6 - 3 + 1, var7 + var9 + 3 - 1, var11, var12);
                this.func_73733_a(var6 + var5 + 2, var7 - 3 + 1, var6 + var5 + 3, var7 + var9 + 3 - 1, var11, var12);
                this.func_73733_a(var6 - 3, var7 - 3, var6 + var5 + 3, var7 - 3 + 1, var11, var11);
                this.func_73733_a(var6 - 3, var7 + var9 + 2, var6 + var5 + 3, var7 + var9 + 3, var12, var12);
                for (int var13 = 0; var13 < toolTips.length; ++var13) {
                    String var14 = toolTips[var13];
                    this.field_73886_k.func_78261_a(var14, var6, var7, -1);
                    var7 += 10;
                }
                this.field_73735_i = 0.0f;
                GL11.glEnable((int)2929);
                GL11.glEnable((int)2896);
                RenderHelper.func_74520_c();
                GL11.glEnable((int)32826);
            }
        }
    }

    protected void displayGauge(int j, int k, int line, int col, int squaled, FluidStack fluid) {
        int x;
        Icon liquidIcon;
        ResourceLocation textureSheet;
        if (fluid == null) {
            return;
        }
        int start = 0;
        if (fluid.getFluid().getIcon() != null) {
            textureSheet = fluid.getFluid().canBePlacedInWorld() ? new ResourceLocation("/terrain.png") : new ResourceLocation("/terrain.png");
            liquidIcon = fluid.getFluid().getIcon();
        } else if (fluid.fluidID < Block.field_71973_m.length && Block.field_71973_m[fluid.fluidID].field_71990_ca > 0) {
            liquidIcon = Block.field_71973_m[fluid.fluidID].func_71858_a(0, 0);
            textureSheet = new ResourceLocation("/terrain.png");
        } else {
            liquidIcon = Item.field_77698_e[fluid.fluidID].func_77617_a(0);
            textureSheet = new ResourceLocation("/gui/items.png");
        }
        this.field_73882_e.field_71446_o.func_110577_a(textureSheet);
        do {
            x = 0;
            if (squaled > 16) {
                x = 16;
                squaled -= 16;
            } else {
                x = squaled;
                squaled = 0;
            }
            this.func_94065_a(j + col, k + line + 58 - x - start, liquidIcon, 16, 16 - (16 - x));
            start += 16;
        } while (x != 0 && squaled != 0);
    }
}

