/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.grid;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.block.INetworkConnection;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.ElectricalEvent;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.IElectricityNetwork;
import universalelectricity.core.path.PathfinderChecker;
import universalelectricity.core.vector.Vector3;

public class ElectricityNetwork
implements IElectricityNetwork {
    public Set<TileEntity> electricalTiles = new HashSet<TileEntity>();
    public Map<TileEntity, ForgeDirection> acceptorDirections = new HashMap<TileEntity, ForgeDirection>();
    private final Set<IConductor> conductors = new HashSet<IConductor>();

    @Override
    public float produce(ElectricityPack electricity, TileEntity ... ignoreTiles) {
        float totalEnergyRequest;
        Set<TileEntity> avaliableEnergyTiles;
        ElectricalEvent.ElectricityProductionEvent evt = new ElectricalEvent.ElectricityProductionEvent(electricity, ignoreTiles);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        float energy = electricity.getWatts();
        float voltage = electricity.voltage;
        if (!evt.isCanceled() && !(avaliableEnergyTiles = this.getAcceptors()).isEmpty() && (totalEnergyRequest = this.getRequest(ignoreTiles).getWatts()) > 0.0f) {
            for (TileEntity tileEntity : avaliableEnergyTiles) {
                IElectrical electricalTile;
                float energyToSend;
                if (!(tileEntity instanceof IElectrical) || Arrays.asList(ignoreTiles).contains(tileEntity) || !((energyToSend = energy * ((electricalTile = (IElectrical)tileEntity).getRequest(ForgeDirection.UNKNOWN) / totalEnergyRequest)) > 0.0f)) continue;
                ElectricityPack electricityToSend = ElectricityPack.getFromWatts(energyToSend, voltage);
                float ampsReceived = electricityToSend.amperes - electricityToSend.amperes * electricityToSend.amperes * this.getTotalResistance() / electricityToSend.voltage;
                float voltsReceived = electricityToSend.voltage - electricityToSend.amperes * this.getTotalResistance();
                electricityToSend = new ElectricityPack(ampsReceived, voltsReceived);
                energy -= ((IElectrical)tileEntity).receiveElectricity(ForgeDirection.UNKNOWN, electricityToSend, true);
            }
        }
        return energy;
    }

    @Override
    public ElectricityPack getRequest(TileEntity ... ignoreTiles) {
        ArrayList<ElectricityPack> requests = new ArrayList<ElectricityPack>();
        Iterator<TileEntity> it = this.getAcceptors().iterator();
        while (it.hasNext()) {
            TileEntity tileEntity = it.next();
            if (Arrays.asList(ignoreTiles).contains(tileEntity)) continue;
            if (tileEntity instanceof IElectrical && !tileEntity.func_70320_p() && tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) == tileEntity) {
                requests.add(ElectricityPack.getFromWatts(((IElectrical)tileEntity).getRequest(ForgeDirection.UNKNOWN), ((IElectrical)tileEntity).getVoltage()));
                continue;
            }
            it.remove();
        }
        ElectricityPack mergedPack = ElectricityPack.merge(requests);
        ElectricalEvent.ElectricityRequestEvent evt = new ElectricalEvent.ElectricityRequestEvent(mergedPack, ignoreTiles);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return mergedPack;
    }

    @Override
    public Set<TileEntity> getAcceptors() {
        return this.electricalTiles;
    }

    @Override
    public void refresh() {
        this.electricalTiles.clear();
        try {
            Iterator<IConductor> it = this.conductors.iterator();
            while (it.hasNext()) {
                IConductor conductor = it.next();
                if (conductor == null) {
                    it.remove();
                } else if (((TileEntity)conductor).func_70320_p()) {
                    it.remove();
                } else {
                    conductor.setNetwork(this);
                }
                for (TileEntity acceptor : conductor.getAdjacentConnections()) {
                    if (acceptor instanceof IConductor) continue;
                    this.electricalTiles.add(acceptor);
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Universal Electricity: Failed to refresh conductor.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public float getTotalResistance() {
        float resistance = 0.0f;
        for (IConductor conductor : this.conductors) {
            resistance += conductor.getResistance();
        }
        return resistance;
    }

    @Override
    public float getLowestCurrentCapacity() {
        float lowestAmperage = 0.0f;
        for (IConductor conductor : this.conductors) {
            if (lowestAmperage != 0.0f && !(conductor.getCurrentCapacity() < lowestAmperage)) continue;
            lowestAmperage = conductor.getCurrentCapacity();
        }
        return lowestAmperage;
    }

    @Override
    public Set<IConductor> getConductors() {
        return this.conductors;
    }

    @Override
    public void merge(IElectricityNetwork network) {
        if (network != null && network != this) {
            ElectricityNetwork newNetwork = new ElectricityNetwork();
            newNetwork.getConductors().addAll(this.getConductors());
            newNetwork.getConductors().addAll(network.getConductors());
            newNetwork.refresh();
        }
    }

    @Override
    public void split(IConductor splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.getConductors().remove(splitPoint);
            TileEntity[] connectedBlocks = splitPoint.getAdjacentConnections();
            for (int i = 0; i < connectedBlocks.length; ++i) {
                TileEntity connectedBlockA = connectedBlocks[i];
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (int ii = 0; ii < connectedBlocks.length; ++ii) {
                    TileEntity connectedBlockB = connectedBlocks[ii];
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).field_70331_k, (INetworkConnection)connectedBlockB, splitPoint);
                    finder.init(new Vector3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (Vector3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    ElectricityNetwork newNetwork = new ElectricityNetwork();
                    for (Vector3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getConductors().add((IConductor)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "ElectricityNetwork[" + this.hashCode() + "|Wires:" + this.conductors.size() + "|Acceptors:" + this.electricalTiles.size() + "]";
    }
}

