/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.path;

import java.util.HashSet;
import java.util.Set;
import universalelectricity.core.path.IPathCallBack;
import universalelectricity.core.vector.Vector3;

public class Pathfinder {
    public IPathCallBack callBackCheck;
    public Set<Vector3> closedSet;
    public Set<Vector3> results;

    public Pathfinder(IPathCallBack callBack) {
        this.callBackCheck = callBack;
        this.reset();
    }

    public boolean findNodes(Vector3 currentNode) {
        this.closedSet.add(currentNode);
        if (this.callBackCheck.onSearch(this, currentNode)) {
            return false;
        }
        for (Vector3 node : this.callBackCheck.getConnectedNodes(this, currentNode)) {
            if (this.closedSet.contains(node) || !this.findNodes(node)) continue;
            return true;
        }
        return false;
    }

    public Pathfinder init(Vector3 startNode) {
        this.findNodes(startNode);
        return this;
    }

    public Pathfinder reset() {
        this.closedSet = new HashSet<Vector3>();
        this.results = new HashSet<Vector3>();
        return this;
    }
}

