/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.path;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.INetworkConnection;
import universalelectricity.core.path.IPathCallBack;
import universalelectricity.core.path.Pathfinder;
import universalelectricity.core.vector.Vector3;

public class PathfinderChecker
extends Pathfinder {
    public PathfinderChecker(final World world, final INetworkConnection targetConnector, final INetworkConnection ... ignoreConnector) {
        super(new IPathCallBack(){

            @Override
            public Set<Vector3> getConnectedNodes(Pathfinder finder, Vector3 currentNode) {
                HashSet<Vector3> neighbors = new HashSet<Vector3>();
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                    Vector3 position = currentNode.clone().modifyPositionFromSide(direction);
                    TileEntity connectedBlock = position.getTileEntity((IBlockAccess)world);
                    if (!(connectedBlock instanceof IConductor) || Arrays.asList(ignoreConnector).contains(connectedBlock) || !((IConductor)connectedBlock).canConnect(direction.getOpposite())) continue;
                    neighbors.add(position);
                }
                return neighbors;
            }

            @Override
            public boolean onSearch(Pathfinder finder, Vector3 node) {
                if (node.getTileEntity((IBlockAccess)world) == targetConnector) {
                    finder.results.add(node);
                    return true;
                }
                return false;
            }
        });
    }
}

