/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import net.minecraft.nbt.NBTTagCompound;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.electricity.ElectricityPack;

public class ElectricityHandler {
    public IElectrical tileEntity;
    public float energyStored = 0.0f;
    public float maxEnergyStored = 0.0f;

    public ElectricityHandler(IElectrical tileEntity) {
        this.tileEntity = tileEntity;
    }

    public ElectricityHandler(IElectrical tileEntity, float maxEnergyStored) {
        this(tileEntity);
        this.setMaxEnergyStored(maxEnergyStored);
    }

    public ElectricityHandler(IElectrical tileEntity, float energyStored, float maxEnergyStored) {
        this(tileEntity);
        this.setEnergyStored(energyStored);
        this.setMaxEnergyStored(maxEnergyStored);
    }

    public float receiveElectricity(ElectricityPack receive, boolean doReceive) {
        if (receive != null) {
            float newStoredEnergy = Math.min(this.getEnergyStored() + receive.getWatts(), this.getMaxEnergyStored());
            if (doReceive) {
                this.setEnergyStored(newStoredEnergy);
            }
            return Math.max(receive.getWatts() - newStoredEnergy, 0.0f);
        }
        return 0.0f;
    }

    public float receiveElectricity(float energy, boolean doReceive) {
        return this.receiveElectricity(ElectricityPack.getFromWatts(energy, this.tileEntity.getVoltage()), doReceive);
    }

    public ElectricityPack provideElectricity(ElectricityPack request, boolean doProvide) {
        if (request != null) {
            float requestedEnergy = Math.min(request.getWatts(), this.energyStored);
            if (doProvide) {
                this.setEnergyStored(this.energyStored - requestedEnergy);
            }
            return ElectricityPack.getFromWatts(requestedEnergy, this.tileEntity.getVoltage());
        }
        return new ElectricityPack();
    }

    public ElectricityPack provideElectricity(float energy, boolean doProvide) {
        return this.provideElectricity(ElectricityPack.getFromWatts(energy, this.tileEntity.getVoltage()), doProvide);
    }

    public ElectricityHandler setEnergyStored(float energy) {
        this.energyStored = Math.max(Math.min(energy, this.getMaxEnergyStored()), 0.0f);
        return this;
    }

    public float getEnergyStored() {
        return this.energyStored;
    }

    public ElectricityHandler setMaxEnergyStored(float maxEnergyStored) {
        this.maxEnergyStored = maxEnergyStored;
        return this;
    }

    public float getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.energyStored = nbt.func_74760_g("energyStored");
        this.maxEnergyStored = nbt.func_74760_g("maxEnergyStored");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("energyStored", this.energyStored);
        nbt.func_74776_a("maxEnergyStored", this.maxEnergyStored);
    }
}

