/*
 * Decompiled with CFR 0.152.
 */
package calclavia.lib;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.common.Loader;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.util.EnumSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.compatiblity.Compatiblity;
import universalelectricity.core.electricity.ElectricalEventHandler;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;
import universalelectricity.prefab.tile.TileEntityElectrical;

public abstract class TileEntityUniversalElectrical
extends TileEntityElectrical
implements IEnergySource,
IPowerReceptor,
IEnergySink {
    private PowerHandler powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);

    @Override
    public void initiate() {
        super.initiate();
        this.powerHandler.configure(0.0f, 2.1474836E9f, 0.0f, (float)Math.ceil(this.getMaxEnergyStored() * Compatiblity.TO_BC_RATIO));
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
    }

    public void func_70313_j() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        super.func_70313_j();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.powerHandler != null) {
            float requiredEnergy = this.getRequest(null) * Compatiblity.TO_BC_RATIO;
            float energyReceived = this.powerHandler.useEnergy(0.0f, requiredEnergy, true);
            this.electricityHandler.receiveElectricity(ElectricityPack.getFromWatts(Compatiblity.BC3_RATIO * energyReceived, this.getVoltage()), true);
        }
    }

    @Deprecated
    public ElectricityPack produce(float watts) {
        ElectricityPack pack = ElectricityPack.getFromWatts(watts, this.getVoltage());
        ElectricityPack remaining = ElectricalEventHandler.produceFromMultipleSides(this, pack);
        if (remaining.getWatts() > 0.0f) {
            EnumSet<ForgeDirection> approachingDirections = ElectricalEventHandler.getDirections(this);
            for (ForgeDirection direction : approachingDirections) {
                PowerHandler.PowerReceiver receiver;
                TileEntity tileEntity = VectorHelper.getTileEntityFromSide(this.field_70331_k, new Vector3(this), direction);
                if (!(tileEntity instanceof IPowerReceptor) || (receiver = ((IPowerReceptor)tileEntity).getPowerReceiver(direction.getOpposite())) == null) continue;
                receiver.receiveEnergy(PowerHandler.Type.MACHINE, remaining.getWatts() * Compatiblity.TO_BC_RATIO, direction.getOpposite());
            }
        }
        if (Loader.isModLoaded((String)"IC2") && remaining.getWatts() > 0.0f) {
            EnergyTileSourceEvent evt = new EnergyTileSourceEvent(this, (int)(remaining.getWatts() * Compatiblity.TO_IC2_RATIO));
            MinecraftForge.EVENT_BUS.post((Event)evt);
            remaining = new ElectricityPack((float)evt.amount * Compatiblity.IC2_RATIO / remaining.voltage, remaining.voltage);
        }
        return remaining;
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        return 0.0f;
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        return 0.0f;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return true;
    }

    @Override
    public float getVoltage() {
        return 120.0f;
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.func_70322_n());
    }

    public void setDirection(ForgeDirection direction) {
        this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, direction.ordinal(), 3);
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return this.canConnect(direction.toForgeDirection());
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return this.canConnect(direction.toForgeDirection());
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.ticks > 0L;
    }

    @Override
    public int demandsEnergy() {
        return (int)Math.ceil(this.getRequest(ForgeDirection.UNKNOWN) * Compatiblity.TO_IC2_RATIO);
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        float givenElectricity = (float)i * Compatiblity.IC2_RATIO;
        float consumed = this.receiveElectricity(direction.toForgeDirection(), ElectricityPack.getFromWatts(givenElectricity, this.getVoltage()), true);
        float rejects = givenElectricity - consumed;
        return (int)(rejects * Compatiblity.TO_IC2_RATIO);
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxEnergyOutput() {
        return Integer.MAX_VALUE;
    }
}

