/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

import cpw.mods.fml.common.FMLLog;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.grid.IElectricityNetwork;

public class NetworkLoader {
    public static Class<? extends IElectricityNetwork> NETWORK_CLASS;
    public static final Set<Class<? extends IElectricityNetwork>> NETWORK_CLASS_REGISTRY;

    public static void setNetworkClass(Class<? extends IElectricityNetwork> networkClass) {
        NETWORK_CLASS_REGISTRY.add(networkClass);
        NETWORK_CLASS = networkClass;
    }

    public static void setNetworkClass(String className) {
        try {
            NetworkLoader.setNetworkClass(Class.forName(className));
        }
        catch (Exception e) {
            FMLLog.severe((String)("Universal Electricity: Failed to set network class with name " + className), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static IElectricityNetwork getNewNetwork(IConductor ... conductors) {
        try {
            IElectricityNetwork network = NETWORK_CLASS.newInstance();
            network.getConductors().addAll(Arrays.asList(conductors));
            return network;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        NETWORK_CLASS_REGISTRY = new HashSet<Class<? extends IElectricityNetwork>>();
        NetworkLoader.setNetworkClass("universalelectricity.core.grid.ElectricityNetwork");
    }
}

