/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;

public class PacketManager
implements IPacketHandler,
IPacketReceiver {
    public static void writeNBTTagCompound(NBTTagCompound tag, DataOutputStream dataStream) throws IOException {
        if (tag == null) {
            dataStream.writeShort(-1);
        } else {
            byte[] var2 = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            dataStream.writeShort((short)var2.length);
            dataStream.write(var2);
        }
    }

    public static NBTTagCompound readNBTTagCompound(ByteArrayDataInput dataStream) throws IOException {
        short var1 = dataStream.readShort();
        if (var1 < 0) {
            return null;
        }
        byte[] var2 = new byte[var1];
        dataStream.readFully(var2);
        return CompressedStreamTools.func_74792_a((byte[])var2);
    }

    public static Packet getPacketWithID(String channelName, int id, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(id);
            data = PacketManager.encodeDataStream(data, sendData);
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = channelName;
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static Packet getPacket(String channelName, Object ... sendData) {
        return PacketManager.getPacketWithID(channelName, PacketType.UNSPECIFIED.ordinal(), sendData);
    }

    public static Packet getPacket(String channelName, TileEntity sender, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(PacketType.TILEENTITY.ordinal());
            data.writeInt(sender.field_70329_l);
            data.writeInt(sender.field_70330_m);
            data.writeInt(sender.field_70327_n);
            data = PacketManager.encodeDataStream(data, sendData);
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = channelName;
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static void sendPacketToClients(Packet packet, World worldObj, Vector3 position, double range) {
        try {
            PacketDispatcher.sendPacketToAllAround((double)position.x, (double)position.y, (double)position.z, (double)range, (int)worldObj.field_73011_w.field_76574_g, (Packet)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(Packet packet, World worldObj) {
        try {
            PacketDispatcher.sendPacketToAllInDimension((Packet)packet, (int)worldObj.field_73011_w.field_76574_g);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(Packet packet) {
        try {
            PacketDispatcher.sendPacketToAllPlayers((Packet)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static DataOutputStream encodeDataStream(DataOutputStream data, Object ... sendData) {
        try {
            for (Object dataValue : sendData) {
                if (dataValue instanceof Integer) {
                    data.writeInt((Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Float) {
                    data.writeFloat(((Float)dataValue).floatValue());
                    continue;
                }
                if (dataValue instanceof Double) {
                    data.writeDouble((Double)dataValue);
                    continue;
                }
                if (dataValue instanceof Byte) {
                    data.writeByte(((Byte)dataValue).byteValue());
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    data.writeBoolean((Boolean)dataValue);
                    continue;
                }
                if (dataValue instanceof String) {
                    data.writeUTF((String)dataValue);
                    continue;
                }
                if (dataValue instanceof Short) {
                    data.writeShort(((Short)dataValue).shortValue());
                    continue;
                }
                if (dataValue instanceof Long) {
                    data.writeLong((Long)dataValue);
                    continue;
                }
                if (!(dataValue instanceof NBTTagCompound)) continue;
                PacketManager.writeNBTTagCompound((NBTTagCompound)dataValue, data);
            }
            return data;
        }
        catch (IOException e) {
            System.out.println("Packet data encoding failed.");
            e.printStackTrace();
            return data;
        }
    }

    public void onPacketData(INetworkManager network, Packet250CustomPayload packet, Player player) {
        try {
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.field_73629_c);
            int packetTypeID = data.readInt();
            PacketType packetType = PacketType.get(packetTypeID);
            if (packetType == PacketType.TILEENTITY) {
                TileEntity tileEntity;
                int x = data.readInt();
                int y = data.readInt();
                int z = data.readInt();
                World world = ((EntityPlayer)player).field_70170_p;
                if (world != null && (tileEntity = world.func_72796_p(x, y, z)) != null && tileEntity instanceof IPacketReceiver) {
                    ((IPacketReceiver)tileEntity).handlePacketData(network, packetTypeID, packet, (EntityPlayer)player, data);
                }
            } else {
                this.handlePacketData(network, packetTypeID, packet, (EntityPlayer)player, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
    }

    public static enum PacketType {
        UNSPECIFIED,
        TILEENTITY;


        public static PacketType get(int id) {
            if (id >= 0 && id < PacketType.values().length) {
                return PacketType.values()[id];
            }
            return UNSPECIFIED;
        }
    }
}

