/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.util.ItemID;
import bspkrs.util.ListUtils;
import java.util.ArrayList;
import java.util.List;

public class ToolRegistry {
    private static ToolRegistry instance;
    private List<ItemID> axeList;
    private List<ItemID> shearsList;
    private List<ItemID> vanAxeList;
    private List<ItemID> vanShearsList;

    public static ToolRegistry instance() {
        if (instance == null) {
            new ToolRegistry();
        }
        return instance;
    }

    protected ToolRegistry() {
        instance = this;
        this.initLists();
        this.initVanillaItemLists();
    }

    protected void initLists() {
        this.axeList = new ArrayList<ItemID>();
        this.shearsList = new ArrayList<ItemID>();
    }

    protected void initVanillaLists() {
        this.vanAxeList = new ArrayList<ItemID>();
        this.vanShearsList = new ArrayList<ItemID>();
    }

    protected void initVanillaItemLists() {
        this.initVanillaLists();
        this.vanAxeList.add(new ItemID(yb.w));
        this.vanAxeList.add(new ItemID(yb.A));
        this.vanAxeList.add(new ItemID(yb.j));
        this.vanAxeList.add(new ItemID(yb.L));
        this.vanAxeList.add(new ItemID(yb.E));
        this.vanShearsList.add(new ItemID((yb)yb.bg));
    }

    protected void readFromNBT(bx ntc) {
        this.axeList = ListUtils.getDelimitedStringAsItemIDList((String)ntc.i("axeIDList"), (String)";");
        this.shearsList = ListUtils.getDelimitedStringAsItemIDList((String)ntc.i("shearsIDList"), (String)";");
    }

    public void writeToNBT(bx ntc) {
        ntc.a("axeIDList", ListUtils.getListAsDelimitedString(this.axeList, (String)";"));
        ntc.a("shearsIDList", ListUtils.getListAsDelimitedString(this.shearsList, (String)";"));
    }

    public void registerAxe(ItemID axe) {
        if (axe != null && !this.axeList.contains(axe)) {
            this.axeList.add(axe);
        }
    }

    public void registerShears(ItemID shears) {
        if (shears != null && !this.shearsList.contains(shears)) {
            this.shearsList.add(shears);
        }
    }

    public List<ItemID> axeList() {
        return new ArrayList<ItemID>(this.axeList);
    }

    public List<ItemID> shearsList() {
        return new ArrayList<ItemID>(this.shearsList);
    }

    public List<ItemID> vanillaAxeList() {
        return new ArrayList<ItemID>(this.vanAxeList);
    }

    public List<ItemID> vanillaShearsList() {
        return new ArrayList<ItemID>(this.vanShearsList);
    }

    public boolean isAxe(ItemID itemID) {
        return this.axeList.contains(itemID);
    }

    public boolean isAxe(yb item) {
        if (item != null) {
            return this.axeList.contains(new ItemID(item));
        }
        return false;
    }

    public boolean isAxe(yd itemStack) {
        if (itemStack != null) {
            return this.axeList.contains(new ItemID(itemStack));
        }
        return false;
    }

    public boolean isShears(ItemID itemID) {
        return this.shearsList.contains(itemID);
    }

    public boolean isShears(yb item) {
        if (item != null) {
            return this.shearsList.contains(new ItemID(item));
        }
        return false;
    }

    public boolean isShears(yd itemStack) {
        if (itemStack != null) {
            return this.shearsList.contains(new ItemID(itemStack));
        }
        return false;
    }
}

