/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.power;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import net.minecraftforge.common.ForgeDirection;

public abstract class PowerProvider
implements IPowerProvider {
    protected int latency;
    protected int minEnergyReceived;
    protected int maxEnergyReceived;
    protected int maxEnergyStored;
    protected int minActivationEnergy;
    protected float energyStored = 0.0f;
    protected int powerLoss = 1;
    protected int powerLossRegularity = 100;
    public SafeTimeTracker timeTracker = new SafeTimeTracker();
    public SafeTimeTracker energyLossTracker = new SafeTimeTracker();
    public int[] powerSources = new int[]{0, 0, 0, 0, 0, 0};

    @Override
    public SafeTimeTracker getTimeTracker() {
        return this.timeTracker;
    }

    @Override
    public int getLatency() {
        return this.latency;
    }

    @Override
    public int getMinEnergyReceived() {
        return this.minEnergyReceived;
    }

    @Override
    public int getMaxEnergyReceived() {
        return this.maxEnergyReceived;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    @Override
    public int getActivationEnergy() {
        return this.minActivationEnergy;
    }

    @Override
    public float getEnergyStored() {
        return this.energyStored;
    }

    @Override
    public void configure(int latency, int minEnergyReceived, int maxEnergyReceived, int minActivationEnergy, int maxStoredEnergy) {
        this.latency = latency;
        this.minEnergyReceived = minEnergyReceived;
        this.maxEnergyReceived = maxEnergyReceived;
        this.maxEnergyStored = maxStoredEnergy;
        this.minActivationEnergy = minActivationEnergy;
    }

    @Override
    public void configurePowerPerdition(int powerLoss, int powerLossRegularity) {
        this.powerLoss = powerLoss;
        this.powerLossRegularity = powerLossRegularity;
    }

    @Override
    public boolean update(IPowerReceptor receptor) {
        if (!this.preConditions(receptor)) {
            return false;
        }
        aqp tile = (aqp)receptor;
        boolean result = false;
        if (this.energyStored >= (float)this.minActivationEnergy) {
            if (this.latency == 0) {
                receptor.doWork();
                result = true;
            } else if (this.timeTracker.markTimeIfDelay(tile.k, this.latency)) {
                receptor.doWork();
                result = true;
            }
        }
        if (this.powerLoss > 0 && this.energyLossTracker.markTimeIfDelay(tile.k, this.powerLossRegularity)) {
            this.energyStored -= (float)this.powerLoss;
            if (this.energyStored < 0.0f) {
                this.energyStored = 0.0f;
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (this.powerSources[i] <= 0) continue;
            int n = i;
            this.powerSources[n] = this.powerSources[n] - 1;
        }
        return result;
    }

    @Override
    public boolean preConditions(IPowerReceptor receptor) {
        return true;
    }

    @Override
    public float useEnergy(float min, float max, boolean doUse) {
        float result = 0.0f;
        if (this.energyStored >= min) {
            if (this.energyStored <= max) {
                result = this.energyStored;
                if (doUse) {
                    this.energyStored = 0.0f;
                }
            } else {
                result = max;
                if (doUse) {
                    this.energyStored -= max;
                }
            }
        }
        return result;
    }

    @Override
    public void readFromNBT(bs nbttagcompound) {
        this.latency = nbttagcompound.e("latency");
        this.minEnergyReceived = nbttagcompound.e("minEnergyReceived");
        this.maxEnergyReceived = nbttagcompound.e("maxEnergyReceived");
        this.maxEnergyStored = nbttagcompound.e("maxStoreEnergy");
        this.minActivationEnergy = nbttagcompound.e("minActivationEnergy");
        try {
            this.energyStored = nbttagcompound.g("storedEnergy");
        }
        catch (Throwable c) {
            this.energyStored = 0.0f;
        }
    }

    @Override
    public void writeToNBT(bs nbttagcompound) {
        nbttagcompound.a("latency", this.latency);
        nbttagcompound.a("minEnergyReceived", this.minEnergyReceived);
        nbttagcompound.a("maxEnergyReceived", this.maxEnergyReceived);
        nbttagcompound.a("maxStoreEnergy", this.maxEnergyStored);
        nbttagcompound.a("minActivationEnergy", this.minActivationEnergy);
        nbttagcompound.a("storedEnergy", this.energyStored);
    }

    @Override
    public void receiveEnergy(float quantity, ForgeDirection from) {
        this.powerSources[from.ordinal()] = 2;
        this.energyStored += quantity;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public boolean isPowerSource(ForgeDirection from) {
        return this.powerSources[from.ordinal()] != 0;
    }
}

