/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import mekanism.api.EnumGas;
import mekanism.api.GasTransmission;
import mekanism.api.IGasAcceptor;
import mekanism.api.IGasStorage;
import mekanism.api.IPressurizedTube;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class GasTransferProtocol {
    public ArrayList iteratedTubes = new ArrayList();
    public ArrayList availableAcceptors = new ArrayList();
    public aqp pointer;
    public aqp original;
    public EnumGas transferType;
    public int gasToSend;

    public GasTransferProtocol(aqp head, aqp orig, EnumGas type, int amount) {
        this.pointer = head;
        this.transferType = type;
        this.gasToSend = amount;
        this.original = orig;
    }

    public void loopThrough(aqp tile) {
        aqp[] tubes;
        IGasAcceptor[] acceptors;
        for (IGasAcceptor acceptor : acceptors = GasTransmission.getConnectedAcceptors(tile)) {
            if (acceptor == null || this.availableAcceptors.contains(acceptor) || acceptor == this.original || !acceptor.canReceiveGas(ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)).getOpposite(), this.transferType) || acceptor instanceof IGasStorage && (!(acceptor instanceof IGasStorage) || ((IGasStorage)((Object)acceptor)).getMaxGas(this.transferType, new Object[0]) - ((IGasStorage)((Object)acceptor)).getGas(this.transferType, new Object[0]) <= 0)) continue;
            this.availableAcceptors.add(acceptor);
        }
        if (!this.iteratedTubes.contains(tile)) {
            this.iteratedTubes.add(tile);
        }
        for (aqp tube : tubes = GasTransmission.getConnectedTubes(tile)) {
            if (tube == null || this.iteratedTubes.contains(tube)) continue;
            this.loopThrough(tube);
        }
    }

    public void clientUpdate() {
        this.loopThrough(this.pointer);
        for (aqp tileEntity : this.iteratedTubes) {
            if (!(tileEntity instanceof IPressurizedTube)) continue;
            ((IPressurizedTube)tileEntity).onTransfer(this.transferType);
        }
    }

    public int calculate() {
        this.loopThrough(this.pointer);
        Collections.shuffle(this.availableAcceptors);
        int prevSending = this.gasToSend;
        if (!this.availableAcceptors.isEmpty()) {
            int divider = this.availableAcceptors.size();
            int remaining = this.gasToSend % divider;
            int sending = (this.gasToSend - remaining) / divider;
            for (IGasAcceptor acceptor : this.availableAcceptors) {
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                this.gasToSend -= currentSending - acceptor.transferGasToAcceptor(currentSending, this.transferType);
            }
        }
        if (prevSending > this.gasToSend && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            MinecraftForge.EVENT_BUS.post((Event)new GasTransferEvent(this));
        }
        return this.gasToSend;
    }

    public static class GasTransferEvent
    extends Event {
        public final GasTransferProtocol transferProtocol;

        public GasTransferEvent(GasTransferProtocol protocol) {
            this.transferProtocol = protocol;
        }
    }
}

