/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.EnumGas;
import mekanism.api.GasTransferProtocol;
import mekanism.api.IGasAcceptor;
import mekanism.api.IPressurizedTube;
import mekanism.api.ITubeConnection;
import mekanism.api.Object3D;
import net.minecraftforge.common.ForgeDirection;

public final class GasTransmission {
    public static aqp[] getConnectedTubes(aqp tileEntity) {
        aqp[] tubes = new aqp[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            aqp tube = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity(tileEntity.k);
            if (!(tube instanceof IPressurizedTube) || !((IPressurizedTube)tube).canTransferGas(tileEntity)) continue;
            tubes[orientation.ordinal()] = tube;
        }
        return tubes;
    }

    public static IGasAcceptor[] getConnectedAcceptors(aqp tileEntity) {
        IGasAcceptor[] acceptors = new IGasAcceptor[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            aqp acceptor = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity(tileEntity.k);
            if (!(acceptor instanceof IGasAcceptor)) continue;
            acceptors[orientation.ordinal()] = (IGasAcceptor)acceptor;
        }
        return acceptors;
    }

    public static ITubeConnection[] getConnections(aqp tileEntity) {
        ITubeConnection[] connections = new ITubeConnection[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            aqp connection = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity(tileEntity.k);
            if (!(connection instanceof ITubeConnection)) continue;
            connections[orientation.ordinal()] = (ITubeConnection)connection;
        }
        return connections;
    }

    public static int emitGasToNetwork(EnumGas type, int amount, aqp sender, ForgeDirection facing) {
        aqp pointer = Object3D.get(sender).getFromSide(facing).getTileEntity(sender.k);
        if (pointer instanceof IPressurizedTube) {
            return new GasTransferProtocol(pointer, sender, type, amount).calculate();
        }
        return amount;
    }

    public static int emitGasFromAllSides(EnumGas type, int amount, aqp pointer) {
        if (pointer != null) {
            return new GasTransferProtocol(pointer, pointer, type, amount).calculate();
        }
        return amount;
    }
}

