/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.API;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import micdoodle8.mods.galacticraft.API.ISchematicPage;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketSchematicList;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;

public class SchematicRegistry {
    public static ArrayList schematicRecipes = new ArrayList();

    public static void registerSchematicRecipe(ISchematicPage page) {
        if (!schematicRecipes.contains(page)) {
            schematicRecipes.add(page);
        }
    }

    public static ISchematicPage getMatchingRecipeForItemStack(wm stack) {
        for (ISchematicPage schematic : schematicRecipes) {
            wm requiredItem = schematic.getRequiredItem();
            if (requiredItem == null || stack == null || !requiredItem.a(stack)) continue;
            return schematic;
        }
        return null;
    }

    public static ISchematicPage getMatchingRecipeForID(int id) {
        for (ISchematicPage schematic : schematicRecipes) {
            if (schematic.getPageID() != id) continue;
            return schematic;
        }
        return null;
    }

    public static void addUnlockedPage(GCCorePlayerMP player, ISchematicPage page) {
        if (!player.unlockedSchematics.contains(page)) {
            player.unlockedSchematics.add(page);
            Collections.sort(player.unlockedSchematics);
            if (player != null && player.a != null) {
                player.a.b(GCCorePacketSchematicList.buildSchematicListPacket(player.unlockedSchematics));
            }
        }
    }

    public static ISchematicPage unlockNewPage(GCCorePlayerMP player, wm stack) {
        ISchematicPage schematic;
        if (stack != null && (schematic = SchematicRegistry.getMatchingRecipeForItemStack(stack)) != null) {
            SchematicRegistry.addUnlockedPage(player, schematic);
            return schematic;
        }
        return null;
    }

    public static ca writeToNBT(GCCorePlayerMP player, ca par1NBTTagList) {
        Collections.sort(player.unlockedSchematics);
        for (ISchematicPage page : player.unlockedSchematics) {
            if (page == null) continue;
            bs nbttagcompound = new bs();
            nbttagcompound.a("UnlockedPage", page.getPageID());
            par1NBTTagList.a((cf)nbttagcompound);
        }
        return par1NBTTagList;
    }

    public static void readFromNBT(GCCorePlayerMP player, ca par1NBTTagList) {
        player.unlockedSchematics = new ArrayList();
        for (int i = 0; i < par1NBTTagList.c(); ++i) {
            bs nbttagcompound = (bs)par1NBTTagList.b(i);
            int j = nbttagcompound.e("UnlockedPage");
            SchematicRegistry.addUnlockedPage(player, SchematicRegistry.getMatchingRecipeForID(j));
        }
        Collections.sort(player.unlockedSchematics);
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getNextSchematic(int currentIndex) {
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>();
        for (int i = 0; i < PlayerUtil.getPlayerBaseClientFromPlayer((sq)FMLClientHandler.instance().getClient().g).unlockedSchematics.size(); ++i) {
            idList.put(i, ((ISchematicPage)PlayerUtil.getPlayerBaseClientFromPlayer((sq)FMLClientHandler.instance().getClient().g).unlockedSchematics.get(i)).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count + 1 < PlayerUtil.getPlayerBaseClientFromPlayer((sq)FMLClientHandler.instance().getClient().g).unlockedSchematics.size()) {
                return (ISchematicPage)PlayerUtil.getPlayerBaseClientFromPlayer((sq)FMLClientHandler.instance().getClient().g).unlockedSchematics.get(count + 1);
            }
            return null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getLastSchematic(int currentIndex) {
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>();
        for (int i = 0; i < PlayerUtil.getPlayerBaseClientFromPlayer((sq)FMLClientHandler.instance().getClient().g).unlockedSchematics.size(); ++i) {
            idList.put(i, ((ISchematicPage)PlayerUtil.getPlayerBaseClientFromPlayer((sq)FMLClientHandler.instance().getClient().g).unlockedSchematics.get(i)).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count - 1 >= 0) {
                return (ISchematicPage)PlayerUtil.getPlayerBaseClientFromPlayer((sq)FMLClientHandler.instance().getClient().g).unlockedSchematics.get(count - 1);
            }
            return null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void flipToNextPage(int currentIndex) {
        ISchematicPage page = SchematicRegistry.getNextSchematic(currentIndex);
        if (page != null) {
            int nextID = page.getPageID();
            int nextGuiID = page.getGuiID();
            Object[] toSend = new Object[]{nextID};
            FMLClientHandler.instance().getClient().s = null;
            PacketDispatcher.sendPacketToServer((ei)PacketUtil.createPacket("GalacticraftCore", 4, toSend));
            FMLClientHandler.instance().getClient().g.openGui((Object)GalacticraftCore.instance, nextGuiID, FMLClientHandler.instance().getClient().g.q, (int)FMLClientHandler.instance().getClient().g.u, (int)FMLClientHandler.instance().getClient().g.v, (int)FMLClientHandler.instance().getClient().g.w);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void flipToLastPage(int currentIndex) {
        ISchematicPage page = SchematicRegistry.getLastSchematic(currentIndex);
        if (page != null) {
            int nextID = page.getPageID();
            int nextGuiID = page.getGuiID();
            Object[] toSend = new Object[]{nextID};
            FMLClientHandler.instance().getClient().s = null;
            PacketDispatcher.sendPacketToServer((ei)PacketUtil.createPacket("GalacticraftCore", 4, toSend));
            FMLClientHandler.instance().getClient().g.openGui((Object)GalacticraftCore.instance, nextGuiID, FMLClientHandler.instance().getClient().g.q, (int)FMLClientHandler.instance().getClient().g.u, (int)FMLClientHandler.instance().getClient().g.v, (int)FMLClientHandler.instance().getClient().g.w);
        }
    }
}

