/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAirLock;
import universalelectricity.core.vector.Vector3;

public class AirLockProtocol {
    ArrayList adjacentAirLocks = new ArrayList();
    private final aab worldObj;
    private final aqp head;
    private final int maxLoops;
    public int airLocksVerticalMin = 0;
    public int airLocksVerticalMax = 0;
    public int airLocksHorizontalMin = 0;
    public int airLocksHorizontalMax = 0;
    public int minX = 6000000;
    public int maxX = -6000000;
    public int minY = 6000000;
    public int maxY = -6000000;
    public int minZ = 6000000;
    public int maxZ = -6000000;

    public AirLockProtocol(aqp head, int maxLoops) {
        this.worldObj = head.k;
        this.head = head;
        this.maxLoops = maxLoops;
    }

    public void loopThrough(aqp tile2, int loops) {
        if (loops > 0) {
            for (int y = -1; y <= 1; ++y) {
                for (int x2 = -1; x2 <= 1; ++x2) {
                    for (int z2 = -1; z2 <= 1; ++z2) {
                        aqp tile = this.worldObj.r(tile2.l + x2, tile2.m + y, tile2.n + z2);
                        Vector3 vec = new Vector3(this.head).add(new Vector3(x2, y, z2));
                        if (x2 == 0 && y == 0 && z2 == 0 || tile == null || !(tile instanceof GCCoreTileEntityAirLock) || this.adjacentAirLocks.contains((Object)((GCCoreTileEntityAirLock)tile))) continue;
                        this.adjacentAirLocks.add((GCCoreTileEntityAirLock)tile);
                        this.loopThrough(tile, loops - 1);
                    }
                }
            }
        }
    }

    public ArrayList calculate() {
        aqp tileAt;
        int y;
        if (this.worldObj.I) {
            return null;
        }
        this.adjacentAirLocks = new ArrayList();
        this.loopThrough(this.head, this.maxLoops);
        for (GCCoreTileEntityAirLock airLock : this.adjacentAirLocks) {
            Vector3 vecAt = new Vector3(airLock);
            if (vecAt.intX() < this.minX) {
                this.minX = vecAt.intX();
            }
            if (vecAt.intX() > this.maxX) {
                this.maxX = vecAt.intX();
            }
            if (vecAt.intY() < this.minY) {
                this.minY = vecAt.intY();
            }
            if (vecAt.intY() > this.maxY) {
                this.maxY = vecAt.intY();
            }
            if (vecAt.intZ() < this.minZ) {
                this.minZ = vecAt.intZ();
            }
            if (vecAt.intZ() <= this.maxZ) continue;
            this.maxZ = vecAt.intZ();
        }
        int count = this.maxX - this.minX + (this.maxZ - this.minZ) + (this.maxY - this.minY);
        if (count > 16 || this.maxX - this.minX == 0 && this.maxZ - this.minZ == 0) {
            return null;
        }
        this.airLocksVerticalMin = 0;
        this.airLocksVerticalMax = 0;
        this.airLocksHorizontalMin = 0;
        this.airLocksHorizontalMax = 0;
        for (y = this.minY; y <= this.maxY; ++y) {
            tileAt = new Vector3(this.minX, y, this.minZ).getTileEntity((aak)this.worldObj);
            if (!(tileAt instanceof GCCoreTileEntityAirLock)) continue;
            ++this.airLocksVerticalMin;
        }
        for (y = this.minY; y <= this.maxY; ++y) {
            tileAt = new Vector3(this.maxX, y, this.maxZ).getTileEntity((aak)this.worldObj);
            if (!(tileAt instanceof GCCoreTileEntityAirLock)) continue;
            ++this.airLocksVerticalMax;
        }
        if (this.minX != this.maxX) {
            int x2;
            for (x2 = this.minX; x2 <= this.maxX; ++x2) {
                tileAt = new Vector3(x2, this.maxY, this.maxZ).getTileEntity((aak)this.worldObj);
                if (!(tileAt instanceof GCCoreTileEntityAirLock)) continue;
                ++this.airLocksHorizontalMax;
            }
            for (x2 = this.minX; x2 <= this.maxX; ++x2) {
                tileAt = new Vector3(x2, this.minY, this.maxZ).getTileEntity((aak)this.worldObj);
                if (!(tileAt instanceof GCCoreTileEntityAirLock)) continue;
                ++this.airLocksHorizontalMin;
            }
        } else if (this.minZ != this.maxZ) {
            int z2;
            for (z2 = this.minZ; z2 <= this.maxZ; ++z2) {
                tileAt = new Vector3(this.maxX, this.maxY, z2).getTileEntity((aak)this.worldObj);
                if (!(tileAt instanceof GCCoreTileEntityAirLock)) continue;
                ++this.airLocksHorizontalMax;
            }
            for (z2 = this.minZ; z2 <= this.maxZ; ++z2) {
                tileAt = new Vector3(this.maxX, this.minY, z2).getTileEntity((aak)this.worldObj);
                if (!(tileAt instanceof GCCoreTileEntityAirLock)) continue;
                ++this.airLocksHorizontalMin;
            }
        }
        if (this.airLocksHorizontalMax == 0 || this.airLocksHorizontalMin == 0 || this.airLocksVerticalMin == 0 || this.airLocksVerticalMax == 0 || this.airLocksHorizontalMax != this.airLocksHorizontalMin || this.airLocksVerticalMax != this.airLocksVerticalMin) {
            return null;
        }
        return this.adjacentAirLocks;
    }
}

