/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectric;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreLinkedPowerProvider
extends PowerProvider {
    public GCCoreTileEntityElectric electricTile;

    public GCCoreLinkedPowerProvider(GCCoreTileEntityElectric tile) {
        this.electricTile = tile;
    }

    @Override
    public boolean update(IPowerReceptor receptor) {
        return true;
    }

    @Override
    public float useEnergy(float min, float max, boolean doUse) {
        float result = 0.0f;
        if (this.electricTile.bcEnergy * GalacticraftCore.toBuildcraftEnergyScalar >= (double)min) {
            if (this.electricTile.bcEnergy * GalacticraftCore.toBuildcraftEnergyScalar <= (double)max) {
                result = (float)(this.electricTile.bcEnergy * GalacticraftCore.toBuildcraftEnergyScalar);
                if (doUse) {
                    this.electricTile.bcEnergy = 0.0;
                }
            } else {
                result = max;
                if (doUse) {
                    this.electricTile.bcEnergy -= (double)max * GalacticraftCore.fromBuildcraftEnergyScalar;
                }
            }
        }
        return result;
    }

    @Override
    public void receiveEnergy(float quantity, ForgeDirection from) {
        this.electricTile.bcEnergy = Math.max(Math.min(this.electricTile.bcEnergy + (double)quantity * GalacticraftCore.fromBuildcraftEnergyScalar, this.electricTile.maxEnergy), 0.0);
    }
}

