/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import buildcraft.api.power.PowerFramework;
import com.google.common.io.ByteArrayDataInput;
import micdoodle8.mods.galacticraft.API.IRefinableItem;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemOilCanister;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.tile.GCCoreLinkedPowerProvider;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectric;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import universalelectricity.core.item.IItemElectric;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.PacketManager;

public class GCCoreTileEntityRefinery
extends GCCoreTileEntityElectric
implements lt,
md,
ITankContainer {
    private final int tankCapacity = 24000;
    public LiquidTank oilTank = new LiquidTank(this.tankCapacity);
    public LiquidTank fuelTank = new LiquidTank(this.tankCapacity);
    public static final int PROCESS_TIME_REQUIRED = 1000;
    public int processTicks = 0;
    private wm[] containingItems = new wm[3];
    private int playersUsing = 0;
    private final int canisterToTankRatio = this.tankCapacity / GCCoreItems.fuelCanister.n();
    private final int canisterToLiquidStackRatio = 2000 / GCCoreItems.fuelCanister.n();
    private boolean checkOilNextTick = false;
    private boolean lastCheckOilNextTick = false;

    public GCCoreTileEntityRefinery() {
        super(600, 130.0, 1.0, 1.0);
        if (PowerFramework.currentFramework != null) {
            this.bcPowerProvider = new GCCoreLinkedPowerProvider(this);
            this.bcPowerProvider.configure(20, 25, 100, 25, 1000);
        }
    }

    @Override
    public void h() {
        super.h();
        if (!this.k.I) {
            LiquidStack liquid;
            if (this.containingItems[1] != null && (liquid = LiquidContainerRegistry.getLiquidForFilledItem((wm)this.containingItems[1])) != null && LiquidDictionary.findLiquidName((LiquidStack)liquid).equals("Oil") && (this.oilTank.getLiquid() == null || this.oilTank.getLiquid().amount + liquid.amount <= this.oilTank.getCapacity())) {
                this.oilTank.fill(liquid, true);
                if (this.containingItems[1].b() instanceof GCCoreItemOilCanister) {
                    this.containingItems[1] = new wm(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.n());
                } else if (LiquidContainerRegistry.isBucket((wm)this.containingItems[1]) && LiquidContainerRegistry.isFilledContainer((wm)this.containingItems[1])) {
                    int amount = this.containingItems[1].a;
                    this.containingItems[1] = new wm(wk.ax, amount);
                } else {
                    --this.containingItems[1].a;
                    if (this.containingItems[1].a == 0) {
                        this.containingItems[1] = null;
                    }
                }
            }
            if (this.containingItems[2] != null && LiquidContainerRegistry.isContainer((wm)this.containingItems[2]) && (liquid = this.fuelTank.getLiquid()) != null && this.fuelTank.getLiquidName() != null && this.fuelTank.getLiquidName().equals("Fuel") && LiquidContainerRegistry.isEmptyContainer((wm)this.containingItems[2])) {
                int amountToFill = this.containingItems[2].a(new wm(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.n())) ? 2000 : 1000;
                this.containingItems[2] = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)liquid, (wm)this.containingItems[2]);
                this.fuelTank.drain(amountToFill, true);
            }
            if (this.canProcess()) {
                if (this.processTicks == 0) {
                    this.processTicks = 1000;
                } else if (this.processTicks > 0) {
                    --this.processTicks;
                    if (this.processTicks < 1) {
                        this.smeltItem();
                        this.processTicks = 0;
                    }
                } else {
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
            if (this.checkOilNextTick && this.lastCheckOilNextTick && !this.getDisabled() && (this.oilTank == null || this.oilTank.getLiquid() == null || this.oilTank.getLiquid().amount == 0)) {
                this.setDisabled(true);
                this.checkOilNextTick = false;
            }
            this.lastCheckOilNextTick = this.checkOilNextTick;
        }
    }

    public int getScaledOilLevel(int i) {
        return this.oilTank.getLiquid() != null ? this.oilTank.getLiquid().amount * i / this.oilTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.fuelTank.getLiquid() != null ? this.fuelTank.getLiquid().amount * i / this.fuelTank.getCapacity() : 0;
    }

    public void f() {
        if (!this.k.I) {
            PacketManager.sendPacketToClients(this.getPacket(), this.k, new Vector3(this), 15.0);
        }
        ++this.playersUsing;
    }

    public void g() {
        --this.playersUsing;
    }

    public boolean canProcess() {
        if (this.oilTank.getLiquid() == null || this.oilTank.getLiquid().amount <= 0) {
            return false;
        }
        if (this.getDisabled()) {
            return false;
        }
        return this.ic2Energy != 0.0 || this.bcEnergy != 0.0 || this.wattsReceived != 0.0;
    }

    public void smeltItem() {
        if (this.canProcess()) {
            int oilAmount = this.oilTank.getLiquid().amount;
            int fuelSpace = this.fuelTank.getCapacity() - (this.fuelTank.getLiquid() == null ? 0 : this.fuelTank.getLiquid().amount);
            int amountToDrain = Math.min(oilAmount, fuelSpace);
            this.oilTank.drain(amountToDrain, true);
            this.fuelTank.fill(LiquidDictionary.getLiquid((String)"Fuel", (int)amountToDrain), true);
            this.checkOilNextTick = true;
        }
    }

    @Override
    public void a(bs nbt) {
        super.a(nbt);
        this.processTicks = nbt.e("smeltingTicks");
        ca var2 = nbt.m("Items");
        this.containingItems = new wm[this.j_()];
        for (int var3 = 0; var3 < var2.c(); ++var3) {
            bs var4 = (bs)var2.b(var3);
            byte var5 = var4.c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = wm.a((bs)var4);
        }
        if (nbt.b("oilTank")) {
            this.oilTank.readFromNBT(nbt.l("oilTank"));
        }
        if (nbt.b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.l("fuelTank"));
        }
    }

    @Override
    public void b(bs nbt) {
        super.b(nbt);
        nbt.a("smeltingTicks", this.processTicks);
        ca var2 = new ca();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            bs var4 = new bs();
            var4.a("Slot", (byte)var3);
            this.containingItems[var3].b(var4);
            var2.a((cf)var4);
        }
        nbt.a("Items", (cf)var2);
        if (this.oilTank.getLiquid() != null) {
            nbt.a("oilTank", (cf)this.oilTank.writeToNBT(new bs()));
        }
        if (this.fuelTank.getLiquid() != null) {
            nbt.a("fuelTank", (cf)this.fuelTank.writeToNBT(new bs()));
        }
    }

    public int j_() {
        return this.containingItems.length;
    }

    public wm a(int par1) {
        return this.containingItems[par1];
    }

    public wm a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].a <= par2) {
                wm var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            wm var3 = this.containingItems[par1].a(par2);
            if (this.containingItems[par1].a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public wm b(int par1) {
        if (this.containingItems[par1] != null) {
            wm var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void a(int par1, wm par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.a > this.d()) {
            par2ItemStack.a = this.d();
        }
    }

    public String b() {
        return "Refinery";
    }

    public int d() {
        return 64;
    }

    public boolean a(sq par1EntityPlayer) {
        return this.k.r(this.l, this.m, this.n) != this ? false : par1EntityPlayer.e((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5) <= 64.0;
    }

    public boolean c() {
        return true;
    }

    public boolean b(int slotID, wm itemstack) {
        return slotID == 1 ? itemstack.b() instanceof IRefinableItem && ((IRefinableItem)itemstack.b()).canSmeltItem(itemstack) : (slotID == 0 ? itemstack.b() instanceof IItemElectric : slotID == 2);
    }

    public int[] c(int side) {
        int[] nArray;
        if (side == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else if (side == 0) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = 2;
        }
        return nArray;
    }

    public boolean a(int slotID, wm itemstack, int side) {
        return this.b(slotID, itemstack);
    }

    public boolean b(int slotID, wm itemstack, int side) {
        return slotID == 2;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.p() + 2)).getOpposite())) {
            return this.fill(0, resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        int used = 0;
        LiquidStack resourceUsing = resource.copy();
        String liquidName = LiquidDictionary.findLiquidName((LiquidStack)resource);
        if (tankIndex == 0 && liquidName != null && liquidName.equals("Oil")) {
            used = this.oilTank.fill(resource, doFill);
        }
        return used;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.p() + 2)))) {
            return this.drain(0, maxDrain, doDrain);
        }
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.fuelTank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.oilTank, this.fuelTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.getOrientation((int)(this.p() + 2)).getOpposite()) {
            return this.oilTank;
        }
        if (direction == ForgeDirection.getOrientation((int)(this.p() + 2))) {
            return this.fuelTank;
        }
        return null;
    }

    @Override
    public boolean shouldPullEnergy() {
        return !this.getDisabled() && this.oilTank.getLiquid() != null && this.oilTank.getLiquid().amount > 0;
    }

    @Override
    public void readPacket(ByteArrayDataInput data) {
        if (this.k.I) {
            this.wattsReceived = data.readDouble();
            this.processTicks = data.readInt();
            this.ic2Energy = data.readDouble();
            this.oilTank.setLiquid(new LiquidStack(GCCoreBlocks.crudeOilStill.cz, data.readInt(), 0));
            this.fuelTank.setLiquid(new LiquidStack(GCCoreItems.fuel.cp, data.readInt(), 0));
            this.disabled = data.readBoolean();
            this.bcEnergy = data.readDouble();
        }
    }

    @Override
    public ei getPacket() {
        return PacketManager.getPacket("GalacticraftCore", this, new Object[]{this.wattsReceived, this.processTicks, this.ic2Energy, this.oilTank.getLiquid() == null ? 0 : this.oilTank.getLiquid().amount, this.fuelTank.getLiquid() == null ? 0 : this.fuelTank.getLiquid().amount, this.disabled, this.bcEnergy});
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public wm getBatteryInSlot() {
        return this.a(0);
    }
}

