/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.API.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.API.IGalacticraftSubMod;
import micdoodle8.mods.galacticraft.API.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.API.IMapPlanet;
import micdoodle8.mods.galacticraft.API.IOrbitDimension;
import micdoodle8.mods.galacticraft.API.ISpaceship;
import micdoodle8.mods.galacticraft.API.ITeleportType;
import micdoodle8.mods.galacticraft.API.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.API.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCLog;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreOrbitTeleportType;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreSpaceStationData;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreWorldProvider;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityParaChest;
import micdoodle8.mods.galacticraft.core.entities.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketDimensionListPlanets;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketDimensionListSpaceStations;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketSpaceStationData;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import universalelectricity.core.vector.Vector3;

public class WorldUtil {
    public static Collection registeredSpaceStations;
    public static Collection registeredPlanets;
    public static Collection registeredPlanetNames;
    public static List useless;
    public static List common;
    public static List uncommon;
    public static List rare;
    public static List ultrarare;
    private static MinecraftServer mcServer;

    public static double getGravityForEntity(ng eLiving) {
        if (eLiving.q.t instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)eLiving.q.t;
            return 0.08 - (double)customProvider.getGravity();
        }
        return 0.08;
    }

    public static double getItemGravity(rh e) {
        if (e.q.t instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)e.q.t;
            return (double)0.04f - (customProvider instanceof IOrbitDimension ? 0.05999999910593033 : (double)customProvider.getGravity()) / 1.75;
        }
        return 0.04f;
    }

    public static double getItemGravity2(rh e) {
        if (e.q.t instanceof IGalacticraftWorldProvider) {
            return 1.0;
        }
        return 0.98f;
    }

    public static Vector3 getWorldColor(aab world) {
        if (world.t instanceof GCCoreWorldProvider) {
            return new Vector3(0.5, 0.5, 0.5);
        }
        return new Vector3(1.0, 1.0, 1.0);
    }

    public static float getColorRed(aab world) {
        return (float)WorldUtil.getWorldColor((aab)world).x;
    }

    public static float getColorGreen(aab world) {
        return (float)WorldUtil.getWorldColor((aab)world).y;
    }

    public static float getColorBlue(aab world) {
        return (float)WorldUtil.getWorldColor((aab)world).z;
    }

    public static boolean generateChestContents(aab var1, Random var2, int var3, int var4, int var5) {
        int var7;
        boolean var6 = true;
        var1.f(var3, var4, var5, apa.ay.cz, 0, 3);
        for (var7 = 0; var7 < 4; ++var7) {
            var6 &= WorldUtil.addItemToChest(var1, var2, var3, var4, var5, WorldUtil.getCommonItem(var2));
        }
        for (var7 = 0; var7 < 2; ++var7) {
            var6 &= WorldUtil.addItemToChest(var1, var2, var3, var4, var5, WorldUtil.getUncommonItem(var2));
        }
        for (var7 = 0; var7 < 1; ++var7) {
            var6 &= WorldUtil.addItemToChest(var1, var2, var3, var4, var5, WorldUtil.getRareItem(var2));
        }
        return var6;
    }

    public static wm getCommonItem(Random var1) {
        return var1.nextInt(4) == 0 ? WorldUtil.getRandomItemFromList(useless, var1) : WorldUtil.getRandomItemFromList(common, var1);
    }

    public static wm getUncommonItem(Random var1) {
        return WorldUtil.getRandomItemFromList(uncommon, var1);
    }

    public static wm getRareItem(Random var1) {
        return var1.nextInt(4) == 0 ? WorldUtil.getRandomItemFromList(ultrarare, var1) : WorldUtil.getRandomItemFromList(rare, var1);
    }

    public static wm getRandomItemFromList(List list, Random rand) {
        return (wm)list.get(rand.nextInt(list.size()));
    }

    protected static boolean addItemToChest(aab var1, Random var2, int var3, int var4, int var5, wm var6) {
        int var8;
        apy var7 = (apy)var1.r(var3, var4, var5);
        if (var7 != null && (var8 = WorldUtil.findRandomInventorySlot(var7, var2)) != -1) {
            var7.a(var8, var6);
            return true;
        }
        return false;
    }

    protected static int findRandomInventorySlot(apy var1, Random var2) {
        for (int var3 = 0; var3 < 100; ++var3) {
            int var4 = var2.nextInt(var1.j_());
            if (var1.a(var4) != null) continue;
            return var4;
        }
        return -1;
    }

    public static acn getProviderForName(String par1String) {
        Integer[] var1;
        for (Integer element : var1 = WorldUtil.getArrayOfPossibleDimensions()) {
            if (acn.a((int)element) == null || acn.a((int)element).l() == null) continue;
            if (par1String.contains("$")) {
                String[] twoDimensions = par1String.split("\\$");
                if (!acn.a((int)element).l().equals(twoDimensions[0])) continue;
                return acn.a((int)element);
            }
            if (!acn.a((int)element).l().equals(par1String)) continue;
            return acn.a((int)element);
        }
        return null;
    }

    public static int getAmountOfPossibleProviders(Integer[] ids) {
        int amount = 0;
        for (Integer id : ids) {
            if (!(acn.a((int)id) instanceof IGalacticraftWorldProvider) && acn.a((int)id.intValue()).h != 0) continue;
            ++amount;
        }
        return amount;
    }

    public static HashMap getArrayOfPossibleDimensions(Integer[] ids) {
        return WorldUtil.getArrayOfPossibleDimensions(ids, null);
    }

    public static HashMap getArrayOfPossibleDimensions(Integer[] ids, GCCorePlayerMP playerBase) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Integer id : ids) {
            if (acn.a((int)id) == null) continue;
            if (acn.a((int)id) instanceof IGalacticraftWorldProvider && !(acn.a((int)id) instanceof IOrbitDimension) || acn.a((int)id.intValue()).h == 0) {
                map.put(acn.a((int)id).l(), acn.a((int)id.intValue()).h);
                continue;
            }
            if (playerBase == null || !(acn.a((int)id) instanceof IOrbitDimension)) continue;
            GCCoreSpaceStationData data = GCCoreSpaceStationData.getStationData(playerBase.q, id, (sq)playerBase);
            if (GCCoreConfigManager.spaceStationsRequirePermission && !data.getAllowedPlayers().contains(playerBase.bS.toLowerCase()) && !data.getAllowedPlayers().contains(playerBase.bS)) continue;
            map.put(acn.a((int)id).l() + "$" + data.getOwner(), acn.a((int)id.intValue()).h);
        }
        for (int j = 0; j < GalacticraftCore.subMods.size(); ++j) {
            if (((IGalacticraftSubMod)GalacticraftCore.subMods.get(j)).reachableDestination()) continue;
            map.put(((IGalacticraftSubMod)GalacticraftCore.subMods.get(j)).getDimensionName() + "*", 0);
        }
        return map;
    }

    public static double getSpaceshipFailChance(sq player) {
        Double level = player.cf;
        if (level <= 50.0) {
            return 12.5 - level / 4.0;
        }
        return 0.0;
    }

    public static float calculateMarsAngleFromOtherPlanet(long par1, float par3) {
        int var4 = (int)(par1 % 48000L);
        float var5 = ((float)var4 + par3) / 48000.0f - 0.25f;
        if (var5 < 0.0f) {
            var5 += 1.0f;
        }
        if (var5 > 1.0f) {
            var5 -= 1.0f;
        }
        float var6 = var5;
        var5 = 1.0f - (float)((Math.cos((double)var5 * Math.PI) + 1.0) / 2.0);
        var5 = var6 + (var5 - var6) / 3.0f;
        return var5;
    }

    public static float calculateEarthAngleFromOtherPlanet(long par1, float par3) {
        int var4 = (int)(par1 % 48000L);
        float var5 = ((float)var4 + par3) / 48000.0f - 0.25f;
        if (var5 < 0.0f) {
            var5 += 1.0f;
        }
        if (var5 > 1.0f) {
            var5 -= 1.0f;
        }
        float var6 = var5;
        var5 = 1.0f - (float)((Math.cos((double)var5 * Math.PI) + 1.0) / 2.0);
        var5 = var6 + (var5 - var6) / 3.0f;
        return var5;
    }

    public static List getPlayersOnPlanet(IMapPlanet planet) {
        ArrayList<String> list = new ArrayList<String>();
        for (iz world : DimensionManager.getWorlds()) {
            if (world == null || !(world.t instanceof IGalacticraftWorldProvider) || !planet.getSlotRenderer().getPlanetName().toLowerCase().equals(world.t.l().toLowerCase())) continue;
            for (int j = 0; j < world.C().size(); ++j) {
                if (world.C().get(j) == null || !(world.C().get(j) instanceof sq)) continue;
                list.add(((sq)world.C().get((int)j)).bS);
            }
        }
        return list;
    }

    private static List getExistingSpaceStationList(File var0) {
        ArrayList<Integer> var1 = new ArrayList<Integer>();
        for (File var5 : var0.listFiles()) {
            if (!var5.getName().contains("spacestation_")) continue;
            String var6 = var5.getName();
            var6 = var6.substring(13, var6.length() - 4);
            var1.add(Integer.parseInt(var6));
        }
        return var1;
    }

    public static void unregisterSpaceStations() {
        if (registeredSpaceStations != null) {
            for (Integer var1 : registeredSpaceStations) {
                DimensionManager.unregisterDimension((int)var1);
            }
            registeredSpaceStations = null;
        }
    }

    public static void registerSpaceStations(File var0) {
        registeredSpaceStations = WorldUtil.getExistingSpaceStationList(var0);
        for (Integer var2 : registeredSpaceStations) {
            DimensionManager.registerDimension((int)var2, (int)GCCoreConfigManager.idDimensionOverworldOrbit);
        }
    }

    public static void registerPlanet(int planetID, boolean isStatic) {
        if (registeredPlanets == null) {
            registeredPlanets = new ArrayList();
        }
        registeredPlanets.add(planetID);
        if (isStatic) {
            DimensionManager.registerDimension((int)planetID, (int)planetID);
            GCLog.info("Registered Dimension: " + planetID);
        }
    }

    public static void unregisterPlanets() {
        if (registeredPlanets != null) {
            for (Integer var1 : registeredPlanets) {
                DimensionManager.unregisterDimension((int)var1);
                GCLog.info("Unregistered Dimension: " + var1);
            }
            registeredPlanets = null;
        }
    }

    public static Integer[] getArrayOfPossibleDimensions() {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.add(0);
        for (Integer i : registeredPlanets) {
            temp.add(i);
        }
        for (Integer i : registeredSpaceStations) {
            temp.add(i);
        }
        Integer[] finalArray = new Integer[temp.size()];
        int count = 0;
        for (Integer integ : temp) {
            finalArray[count++] = integ;
        }
        return finalArray;
    }

    public static GCCoreSpaceStationData bindSpaceStationToNewDimension(aab var0, GCCorePlayerMP player) {
        int newID = DimensionManager.getNextFreeDimId();
        GCCoreSpaceStationData data = WorldUtil.createSpaceStation(var0, newID, player);
        Object[] toSend = new Object[]{newID};
        player.a.b((ei)PacketUtil.createPacket("GalacticraftCore", 18, toSend));
        return data;
    }

    public static GCCoreSpaceStationData createSpaceStation(aab var0, int par1, GCCorePlayerMP player) {
        registeredSpaceStations.add(par1);
        DimensionManager.registerDimension((int)par1, (int)GCCoreConfigManager.idDimensionOverworldOrbit);
        MinecraftServer var2 = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (var2 != null) {
            ArrayList<Integer> var1 = new ArrayList<Integer>();
            var1.add(par1);
            var2.ad().a(GCCorePacketDimensionListSpaceStations.buildDimensionListPacket(var1));
        }
        GCCoreSpaceStationData var3 = GCCoreSpaceStationData.getStationData(var0, par1, (sq)player);
        return var3;
    }

    public static void transferEntityToDimension(mp entity, int dimensionID, iz world) {
        WorldUtil.transferEntityToDimension(entity, dimensionID, world, true);
    }

    public static void transferEntityToDimension(mp entity, int dimensionID, iz world, boolean transferInv) {
        if (!world.I) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                ArrayList<Integer> array = new ArrayList<Integer>();
                Iterator i$ = registeredPlanets.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    array.add(i);
                }
                server.ad().a(GCCorePacketDimensionListPlanets.buildDimensionListPacket(array));
            }
            if (mcServer == null) {
                mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            }
            if (mcServer != null) {
                ITeleportType type;
                iz var6 = mcServer.a(dimensionID);
                if (var6 == null) {
                    System.err.println("Cannot Transfer Entity to Dimension: Could not get World for Dimension " + dimensionID);
                }
                if ((type = GalacticraftRegistry.getTeleportTypeForDimension(var6.t.getClass())) != null) {
                    WorldUtil.teleportEntity((aab)var6, entity, dimensionID, type, transferInv);
                }
            }
        }
    }

    private static mp teleportEntity(aab var0, mp var1, int var2, ITeleportType type, boolean transferInv) {
        mp var6 = var1.o;
        if (var1.o != null && var1.o instanceof ISpaceship) {
            var1.a(var1.o);
        }
        boolean var7 = var1.q != var0;
        int prevDimensionID = var1.ar;
        var1.q.a(var1, false);
        GCCorePlayerMP var8 = null;
        if (var1 instanceof GCCorePlayerMP) {
            var8 = (GCCorePlayerMP)var1;
            var8.h();
            if (var7) {
                var8.ar = var2;
                var8.a.b((ei)new er(var8.ar, (byte)var8.q.r, var0.M().u(), var0.Q(), var8.c.b()));
                if (var0.t instanceof GCCoreWorldProvider && registeredSpaceStations.contains((Object)var8)) {
                    var8.a.b(GCCorePacketSpaceStationData.buildSpaceStationDataPacket(var0, var0.t.h, var8));
                }
                ((iz)var1.q).s().c((jc)var8);
            }
            var8.setNotUsingPlanetGui();
        }
        if (var7) {
            WorldUtil.removeEntityFromWorld(var1.q, var1);
        }
        if (var7 && var1 instanceof jc) {
            var1.b(type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).x, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).y, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).z, var1.A, var1.B);
            ((iz)var0).b.c(var0.e((int)type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).intX(), (int)type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).intZ()).l().a, var0.e((int)type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).intX(), (int)type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).intZ()).l().b);
        }
        if (var7 && var1 instanceof sq) {
            var1.b(type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).x, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).y, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).z);
        }
        if (var7) {
            if (!(var1 instanceof sq)) {
                bs var11 = new bs();
                var1.M = false;
                var1.d(var11);
                var1.M = true;
                var1 = mv.a((bs)var11, (aab)var0);
                if (var1 == null) {
                    return null;
                }
            }
            var0.d(var1);
            var1.a(var0);
        }
        if (var7 && var1 instanceof sq) {
            var1.b(type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).x, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).y, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).z, var1.A, var1.B);
        }
        var0.a(var1, false);
        if (var7 && var1 instanceof sq) {
            var1.b(type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).x, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).y, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).z, var1.A, var1.B);
        }
        if (var1 instanceof GCCorePlayerMP) {
            var8 = (GCCorePlayerMP)var1;
            if (var7) {
                var8.b.ad().a((jc)var8, (iz)var0);
            }
            var8.a.a(type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).x, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).y, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).z, var1.A, var1.B);
            GCLog.info("Server attempting to transfer player " + var8.bS + " to dimension " + var0.t.h);
        }
        var0.a(var1, false);
        if (var1 instanceof GCCorePlayerMP) {
            var8 = (GCCorePlayerMP)var1;
            if (type.useParachute()) {
                var8.setParachute(true);
            }
        }
        if (var1 instanceof GCCorePlayerMP && var7) {
            var8 = (GCCorePlayerMP)var1;
            var8.c.a((iz)var0);
            var8.b.ad().b((jc)var8, (iz)var0);
            var8.b.ad().f((jc)var8);
            for (ml var10 : var8.bC()) {
                var8.a.b((ei)new fq(var8.k, var10));
            }
            var8.a.b((ei)new fa(var8.ch, var8.cg, var8.cf));
        }
        if (var8 != null) {
            var1.b(type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).x, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).y, type.getPlayerSpawnLocation((iz)((iz)var1.q), (jc)((jc)var1)).z, var1.A, var1.B);
        } else {
            var1.b(type.getEntitySpawnLocation((iz)((iz)var1.q), (mp)var1).x, type.getEntitySpawnLocation((iz)((iz)var1.q), (mp)var1).y, type.getEntitySpawnLocation((iz)((iz)var1.q), (mp)var1).z, var1.A, var1.B);
        }
        if (var1 instanceof GCCorePlayerMP) {
            GCCoreEntityParaChest chest;
            Vector3 chestVec;
            var8 = (GCCorePlayerMP)var1;
            for (int i = 0; i < 27; ++i) {
                if (transferInv) {
                    if (var8.rocketStacks[i] != null) continue;
                    switch (i) {
                        case 24: {
                            var8.rocketStacks[i] = var8.fuelDamage > 0 && var8.fuelDamage <= GCCoreItems.fuelCanister.n() ? new wm(GCCoreItems.fuelCanister, 1, var8.fuelDamage) : null;
                            break;
                        }
                        case 25: {
                            var8.rocketStacks[i] = type instanceof GCCoreOrbitTeleportType ? null : new wm(GCCoreBlocks.landingPad, 9, 0);
                            break;
                        }
                        case 26: {
                            var8.rocketStacks[i] = new wm(GCCoreItems.spaceship, 1, var8.rocketType);
                        }
                    }
                    continue;
                }
                var8.rocketStacks[i] = null;
            }
            if (var8.chestSpawnCooldown == 0 && (chestVec = type.getParaChestSpawnLocation((iz)var1.q, chest = new GCCoreEntityParaChest(var0, var8.rocketStacks), var8, new Random())) != null) {
                double x = (double)(var8.q.s.nextInt(2) - 1) * 3.0;
                double z = (double)(var8.q.s.nextInt(2) - 1) * 3.0;
                chest.b(chestVec.x, chestVec.y, chestVec.z);
                if (!var0.I) {
                    var0.d((mp)chest);
                }
                var8.chestSpawnCooldown = 200;
            }
        }
        if (var1 != null && var6 != null) {
            if (var1 instanceof jc) {
                var0.a(var1, true);
            }
            var1.a(var6);
        }
        if (var1 instanceof jc) {
            GameRegistry.onPlayerChangedDimension((sq)((jc)var1));
            type.onSpaceDimensionChanged(var0, (jc)var1);
        }
        return var1;
    }

    private static void removeEntityFromWorld(aab var0, mp var1) {
        if (var1 instanceof sq) {
            sq var2 = (sq)var1;
            var2.h();
            var0.h.remove(var2);
            var0.c();
            int var3 = var1.aj;
            int var4 = var1.al;
            if (var1.ai && var0.K().a(var3, var4)) {
                var0.e(var3, var4).b(var1);
                var0.e((int)var3, (int)var4).l = true;
            }
            var0.e.remove(var1);
            var0.b(var1);
        }
        var1.M = false;
    }

    public static SpaceStationRecipe getSpaceStationRecipe(int planetID) {
        for (Integer type : GalacticraftRegistry.getSpaceStationData().keySet()) {
            if (type == null || type != planetID) continue;
            return ((SpaceStationType)GalacticraftRegistry.getSpaceStationData().get(type)).getRecipeForSpaceStation();
        }
        return null;
    }

    static {
        useless = new ArrayList();
        common = new ArrayList();
        uncommon = new ArrayList();
        rare = new ArrayList();
        ultrarare = new ArrayList();
        mcServer = null;
    }
}

