/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon.wgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityCreeper;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySkeleton;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySpider;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityZombie;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.wgen.GCCoreCraterSize;
import micdoodle8.mods.galacticraft.core.wgen.GCCoreMapGenBaseMeta;
import micdoodle8.mods.galacticraft.moon.GCMoonConfigManager;
import micdoodle8.mods.galacticraft.moon.blocks.GCMoonBlocks;
import micdoodle8.mods.galacticraft.moon.wgen.GCMoonBiomeDecorator;
import micdoodle8.mods.galacticraft.moon.wgen.GCMoonBiomeGenBase;
import micdoodle8.mods.galacticraft.moon.wgen.GCMoonGenCaves;
import micdoodle8.mods.galacticraft.moon.wgen.GCMoonMapGenVillage;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCMapGenDungeon;

public class GCMoonChunkProvider
extends acy {
    final short topBlockID;
    final byte topBlockMeta = 5;
    final short fillBlockID;
    final byte fillBlockMeta = 3;
    final short lowerBlockID;
    final byte lowerBlockMeta = 4;
    private final Random rand;
    private final NoiseModule noiseGen1;
    private final NoiseModule noiseGen2;
    private final NoiseModule noiseGen3;
    private final NoiseModule noiseGen4;
    public GCMoonBiomeDecorator biomedecoratorplanet;
    private final aab worldObj;
    private long seed;
    private final boolean mapFeaturesEnabled;
    private double[] noiseArray;
    private final double[] stoneNoise;
    private final GCMoonMapGenVillage villageGenerator;
    private final ael mineshaftGenerator;
    private final GCMapGenDungeon dungeonGenerator;
    private aav[] biomesForGeneration;
    private final GCCoreMapGenBaseMeta caveGenerator;
    private static final double TERRAIN_HEIGHT_MOD = 2.7;
    private static final double HILL_HEIGHT_MOD = 0.8;
    private static final int CRATER_PROB = 300;
    private static final int MID_HEIGHT = 63;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 128;
    private static final int CHUNK_SIZE_Z = 16;
    private static final double HILL_FILTER_MOD = 2.5;
    private int chunkX;
    private int chunkZ;

    public GCMoonChunkProvider(aab par1World, long par2, boolean par4) {
        super(par1World, par2, par4);
        this.topBlockID = (short)GCMoonBlocks.blockMoon.cz;
        this.topBlockMeta = (byte)5;
        this.fillBlockID = (short)GCMoonBlocks.blockMoon.cz;
        this.fillBlockMeta = (byte)3;
        this.lowerBlockID = (short)GCMoonBlocks.blockMoon.cz;
        this.lowerBlockMeta = (byte)4;
        this.biomedecoratorplanet = new GCMoonBiomeDecorator(GCMoonBiomeGenBase.moonFlat);
        this.stoneNoise = new double[256];
        this.villageGenerator = new GCMoonMapGenVillage();
        this.mineshaftGenerator = new ael();
        this.dungeonGenerator = new GCMapGenDungeon();
        this.biomesForGeneration = new aav[]{GCMoonBiomeGenBase.moonFlat};
        this.caveGenerator = new GCMoonGenCaves();
        this.worldObj = par1World;
        this.mapFeaturesEnabled = par4;
        this.rand = new Random(par2);
        this.seed = par2;
        this.noiseGen1 = new Gradient(this.rand.nextLong(), 4, 0.25);
        this.noiseGen2 = new Gradient(this.rand.nextLong(), 4, 0.25);
        this.noiseGen3 = new Gradient(this.rand.nextLong(), 1, 0.25);
        this.noiseGen4 = new Gradient(this.rand.nextLong(), 1, 0.25);
    }

    public void generateTerrain(int chunkX, int chunkZ, short[] idArray, byte[] metaArray) {
        this.noiseGen1.frequency = 0.0125;
        this.noiseGen2.frequency = 0.015;
        this.noiseGen3.frequency = 0.01;
        this.noiseGen4.frequency = 0.02;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double d = this.noiseGen1.getNoise(x + chunkX * 16, z + chunkZ * 16) * 8.0;
                double d2 = this.noiseGen2.getNoise(x + chunkX * 16, z + chunkZ * 16) * 24.0;
                double d3 = this.noiseGen3.getNoise(x + chunkX * 16, z + chunkZ * 16) - 0.1;
                double yDev = 0.0;
                yDev = d3 < 0.0 ? d : (d3 > 1.0 ? d2 : d + (d2 - d) * (d3 *= 4.0));
                for (int y = 0; y < 128; ++y) {
                    if (!((double)y < 63.0 + yDev)) continue;
                    idArray[this.getIndex((int)x, (int)y, (int)z)] = this.lowerBlockID;
                    metaArray[this.getIndex((int)x, (int)y, (int)z)] = this.lowerBlockMeta;
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, short[] arrayOfIDs, byte[] arrayOfMeta, aav[] par4ArrayOfBiomeGenBase) {
        int var5 = 20;
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var12 = (int)(this.noiseGen4.getNoise(var8 + par1 * 16, var9 * par2 * 16) / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var13 = -1;
                short var14 = this.topBlockID;
                int var14m = this.topBlockMeta;
                short var15 = this.fillBlockID;
                int var15m = this.fillBlockMeta;
                for (int var16 = 127; var16 >= 0; --var16) {
                    int index = this.getIndex(var8, var16, var9);
                    arrayOfMeta[index] = 0;
                    if (var16 <= 0 + this.rand.nextInt(5)) {
                        arrayOfIDs[index] = (short)apa.D.cz;
                        continue;
                    }
                    short var18 = arrayOfIDs[index];
                    if (var18 == 0) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != this.lowerBlockID) continue;
                    arrayOfMeta[index] = this.lowerBlockMeta;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            var14 = 0;
                            var14m = 0;
                            var15 = this.lowerBlockID;
                            var15m = this.lowerBlockMeta;
                        } else if (var16 >= 36 && var16 <= 21) {
                            var14 = this.topBlockID;
                            var14m = this.topBlockMeta;
                            var14 = this.fillBlockID;
                            var14m = this.fillBlockMeta;
                        }
                        var13 = var12;
                        if (var16 >= 19) {
                            arrayOfIDs[index] = var14;
                            arrayOfMeta[index] = var14m;
                            continue;
                        }
                        if (var16 >= 19 || var16 < 18) continue;
                        arrayOfIDs[index] = var15;
                        arrayOfMeta[index] = var15m;
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    arrayOfIDs[index] = var15;
                    arrayOfMeta[index] = var15m;
                }
            }
        }
    }

    public abw d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        short[] ids = new short[32768];
        byte[] meta = new byte[32768];
        this.generateTerrain(par1, par2, ids, meta);
        this.biomesForGeneration = this.worldObj.u().b(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.createCraters(par1, par2, ids, meta);
        this.replaceBlocksForBiome(par1, par2, ids, meta, this.biomesForGeneration);
        this.caveGenerator.generate((abt)this, this.worldObj, par1, par2, ids, meta);
        abw var4 = new abw(this.worldObj, ids, meta, par1, par2);
        var4.b();
        return var4;
    }

    public void createCraters(int chunkX, int chunkZ, short[] chunkArray, byte[] metaArray) {
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < this.noiseGen4.getNoise(x * 16 + x, cz * 16 + z) / 300.0)) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        GCCoreCraterSize cSize = GCCoreCraterSize.sizeArray[random.nextInt(GCCoreCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, chunkArray, metaArray);
                    }
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, short[] chunkArray, byte[] metaArray) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (chunkArray[this.getIndex(x, y, z)] != 0 && (double)helper <= yDev) {
                        chunkArray[this.getIndex((int)x, (int)y, (int)z)] = 0;
                        metaArray[this.getIndex((int)x, (int)y, (int)z)] = 0;
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    public boolean a(int par1, int par2) {
        return true;
    }

    public boolean c() {
        return false;
    }

    public int f() {
        return 0;
    }

    private int getIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public void decoratePlanet(aab par1World, Random par2Random, int par3, int par4) {
        this.biomedecoratorplanet.decorate(par1World, par2Random, par3, par4);
    }

    public void a(abt par1IChunkProvider, int par2, int par3) {
        amt.c = true;
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        this.worldObj.a(var4 + 16, var5 + 16);
        this.rand.setSeed(this.worldObj.G());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)par2 * var7 + (long)par3 * var9 ^ this.worldObj.G());
        if (!GCMoonConfigManager.disableMoonVillageGen) {
            this.villageGenerator.a(this.worldObj, this.rand, par2, par3);
        }
        this.decoratePlanet(this.worldObj, this.rand, var4, var5);
        amt.c = false;
    }

    public boolean a(boolean par1, lc par2IProgressUpdate) {
        return true;
    }

    public boolean d() {
        return true;
    }

    public String e() {
        return GCMoonConfigManager.generateOtherMods ? "RandomLevelSource" : "MoonLevelSource";
    }

    public List a(nn par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == nn.a) {
            ArrayList<aaw> monsters = new ArrayList<aaw>();
            monsters.add(new aaw(GCCoreEntityZombie.class, 8, 2, 3));
            monsters.add(new aaw(GCCoreEntitySpider.class, 8, 2, 3));
            monsters.add(new aaw(GCCoreEntitySkeleton.class, 8, 2, 3));
            monsters.add(new aaw(GCCoreEntityCreeper.class, 8, 2, 3));
            return monsters;
        }
        return null;
    }

    public void e(int par1, int par2) {
        if (!GCMoonConfigManager.disableMoonVillageGen) {
            this.villageGenerator.a((abt)this, this.worldObj, par1, par2, null);
        }
    }
}

