/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon.wgen.dungeon;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonBoundingBox;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCMapGenDungeon;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCRoomBoss;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCRoomChests;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCRoomEmpty;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCRoomSpawner;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCRoomTreasure;

public abstract class GCDungeonRoom {
    public aab worldObj;
    public int posX;
    public int posY;
    public int posZ;
    public int entranceDir;
    private static ArrayList rooms = new ArrayList();
    private static ArrayList bossRooms = new ArrayList();
    private static ArrayList treasureRooms = new ArrayList();

    public GCDungeonRoom(aab worldObj, int posX, int posY, int posZ, int entranceDir) {
        this.worldObj = worldObj;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.entranceDir = entranceDir;
    }

    public abstract void generate(short[] var1, byte[] var2, int var3, int var4);

    public abstract GCDungeonBoundingBox getBoundingBox();

    protected abstract GCDungeonRoom makeRoom(aab var1, int var2, int var3, int var4, int var5);

    protected abstract void handleTileEntities(Random var1);

    public static GCDungeonRoom makeRoom(aab worldObj, Random rand, int x, int y, int z, int dir) {
        return ((GCDungeonRoom)rooms.get(rand.nextInt(rooms.size()))).makeRoom(worldObj, x, y, z, dir);
    }

    public static GCDungeonRoom makeBossRoom(aab worldObj, Random rand, int x, int y, int z, int dir) {
        return ((GCDungeonRoom)bossRooms.get(rand.nextInt(bossRooms.size()))).makeRoom(worldObj, x, y, z, dir);
    }

    public static GCDungeonRoom makeTreasureRoom(aab worldObj, Random rand, int x, int y, int z, int dir) {
        return ((GCDungeonRoom)treasureRooms.get(rand.nextInt(treasureRooms.size()))).makeRoom(worldObj, x, y, z, dir);
    }

    protected boolean placeBlock(short[] blocks, byte[] metas, int x, int y, int z, int cx, int cz, int id, int meta) {
        if (GCMapGenDungeon.useArrays) {
            if ((x -= (cx *= 16)) < 0 || x >= 16 || (z -= (cz *= 16)) < 0 || z >= 16) {
                return false;
            }
            int index = this.getIndex(x, y, z);
            blocks[index] = (short)id;
            metas[index] = (byte)meta;
        } else {
            this.worldObj.f(x, y, z, id, meta, 3);
        }
        return true;
    }

    private int getIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    static {
        rooms.add(new GCRoomEmpty(null, 0, 0, 0, 0));
        rooms.add(new GCRoomSpawner(null, 0, 0, 0, 0));
        rooms.add(new GCRoomSpawner(null, 0, 0, 0, 0));
        rooms.add(new GCRoomSpawner(null, 0, 0, 0, 0));
        rooms.add(new GCRoomSpawner(null, 0, 0, 0, 0));
        rooms.add(new GCRoomSpawner(null, 0, 0, 0, 0));
        rooms.add(new GCRoomSpawner(null, 0, 0, 0, 0));
        rooms.add(new GCRoomSpawner(null, 0, 0, 0, 0));
        rooms.add(new GCRoomSpawner(null, 0, 0, 0, 0));
        rooms.add(new GCRoomChests(null, 0, 0, 0, 0));
        rooms.add(new GCRoomChests(null, 0, 0, 0, 0));
        bossRooms.add(new GCRoomBoss(null, 0, 0, 0, 0));
        treasureRooms.add(new GCRoomTreasure(null, 0, 0, 0, 0));
    }
}

