/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon.wgen.dungeon;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonBoundingBox;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCDungeonRoom;
import micdoodle8.mods.galacticraft.moon.wgen.dungeon.GCMapGenDungeon;

public class GCRoomTreasure
extends GCDungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    private ArrayList chests = new ArrayList();

    public GCRoomTreasure(aab worldObj, int posX, int posY, int posZ, int entranceDir) {
        super(worldObj, posX, posY, posZ, entranceDir);
        if (worldObj != null) {
            Random rand = new Random(worldObj.G() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(6) + 7;
            this.sizeY = rand.nextInt(2) + 5;
            this.sizeZ = rand.nextInt(6) + 7;
        }
    }

    @Override
    public void generate(short[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, GCMapGenDungeon.DUNGEON_WALL_ID, 14);
                        continue;
                    }
                    if (!(i != this.posX && i != this.posX + this.sizeX - 1 || k != this.posZ && k != this.posZ + this.sizeZ - 1)) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, apa.bh.cz, 0);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, 0, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        if (this.placeBlock(chunk, meta, hx, this.posY, hz, cx, cz, GCCoreBlocks.treasureChest.cz, 0)) {
            this.chests.add(new t(hx, this.posY, hz));
        }
    }

    @Override
    public GCDungeonBoundingBox getBoundingBox() {
        return new GCDungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected GCDungeonRoom makeRoom(aab worldObj, int x, int y, int z, int dir) {
        return new GCRoomTreasure(worldObj, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
        for (t chestCoords : this.chests) {
            aqp chest = this.worldObj.r(chestCoords.a, chestCoords.b, chestCoords.c);
            if (chest == null || !(chest instanceof lt)) continue;
            int amountOfGoodies = rand.nextInt(5) + 2;
            for (int i = 0; i < amountOfGoodies; ++i) {
                ((lt)chest).a(rand.nextInt(((lt)chest).j_()), this.getLoot(rand));
            }
        }
    }

    private wm getLoot(Random rand) {
        return new wm(wk.k, 1, 0);
    }
}

