/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.electricity.IElectricityNetwork;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;

public class ElectricityNetworkHelper {
    public static void invalidate(aqp tileEntity) {
        for (int i = 0; i < 6; ++i) {
            IElectricityNetwork network;
            ForgeDirection direction = ForgeDirection.getOrientation((int)i);
            aqp checkTile = VectorHelper.getConnectorFromSide(tileEntity.k, new Vector3(tileEntity), direction);
            if (!(checkTile instanceof INetworkProvider) || (network = ((INetworkProvider)checkTile).getNetwork()) == null) continue;
            network.stopRequesting(tileEntity);
            network.stopProducing(tileEntity);
        }
    }

    public static EnumSet getDirections(aqp tileEntity) {
        EnumSet<ForgeDirection> possibleSides = EnumSet.noneOf(ForgeDirection.class);
        if (tileEntity instanceof IConnector) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                if (!((IConnector)tileEntity).canConnect(direction)) continue;
                possibleSides.add(direction);
            }
        }
        return possibleSides;
    }

    public static ElectricityPack produceFromMultipleSides(aqp tileEntity, ElectricityPack electricityPack) {
        return ElectricityNetworkHelper.produceFromMultipleSides(tileEntity, ElectricityNetworkHelper.getDirections(tileEntity), electricityPack);
    }

    public static ElectricityPack produceFromMultipleSides(aqp tileEntity, EnumSet approachingDirection, ElectricityPack producingPack) {
        List connectedNetworks;
        ElectricityPack remainingElectricity = producingPack.clone();
        if (tileEntity != null && approachingDirection != null && (connectedNetworks = ElectricityNetworkHelper.getNetworksFromMultipleSides(tileEntity, approachingDirection)).size() > 0) {
            double wattsPerSide = producingPack.getWatts() / (double)connectedNetworks.size();
            double voltage = producingPack.voltage;
            for (IElectricityNetwork network : connectedNetworks) {
                if (wattsPerSide > 0.0 && producingPack.getWatts() > 0.0) {
                    aqp[] aqpArray = new aqp[]{tileEntity};
                    double amperes = Math.min(wattsPerSide / voltage, network.getRequest((aqp[])aqpArray).amperes);
                    if (!(amperes > 0.0)) continue;
                    network.startProducing(tileEntity, amperes, voltage);
                    remainingElectricity.amperes -= amperes;
                    continue;
                }
                network.stopProducing(tileEntity);
            }
        }
        return remainingElectricity;
    }

    public static ElectricityPack consumeFromMultipleSides(aqp tileEntity, ElectricityPack electricityPack) {
        return ElectricityNetworkHelper.consumeFromMultipleSides(tileEntity, ElectricityNetworkHelper.getDirections(tileEntity), electricityPack);
    }

    public static ElectricityPack consumeFromMultipleSides(aqp tileEntity, EnumSet approachingDirection, ElectricityPack requestPack) {
        List connectedNetworks;
        ElectricityPack consumedPack = new ElectricityPack();
        if (tileEntity != null && approachingDirection != null && (connectedNetworks = ElectricityNetworkHelper.getNetworksFromMultipleSides(tileEntity, approachingDirection)).size() > 0) {
            double wattsPerSide = requestPack.getWatts() / (double)connectedNetworks.size();
            double voltage = requestPack.voltage;
            for (IElectricityNetwork network : connectedNetworks) {
                if (wattsPerSide > 0.0 && requestPack.getWatts() > 0.0) {
                    network.startRequesting(tileEntity, wattsPerSide / voltage, voltage);
                    ElectricityPack receivedPack = network.consumeElectricity(tileEntity);
                    consumedPack.amperes += receivedPack.amperes;
                    consumedPack.voltage = Math.max(consumedPack.voltage, receivedPack.voltage);
                    continue;
                }
                network.stopRequesting(tileEntity);
            }
        }
        return consumedPack;
    }

    public static List getNetworksFromMultipleSides(aqp tileEntity, EnumSet approachingDirection) {
        ArrayList<IElectricityNetwork> connectedNetworks = new ArrayList<IElectricityNetwork>();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection direction = ForgeDirection.getOrientation((int)i);
            if (!approachingDirection.contains(direction)) continue;
            Vector3 position = new Vector3(tileEntity);
            position.modifyPositionFromSide(direction);
            aqp outputConductor = position.getTileEntity((aak)tileEntity.k);
            IElectricityNetwork electricityNetwork = ElectricityNetworkHelper.getNetworkFromTileEntity(outputConductor, direction);
            if (electricityNetwork == null || connectedNetworks.contains(connectedNetworks)) continue;
            connectedNetworks.add(electricityNetwork);
        }
        return connectedNetworks;
    }

    public static IElectricityNetwork getNetworkFromTileEntity(aqp tileEntity, ForgeDirection approachDirection) {
        if (tileEntity != null && tileEntity instanceof INetworkProvider) {
            if (tileEntity instanceof IConnector) {
                if (((IConnector)tileEntity).canConnect(approachDirection.getOpposite())) {
                    return ((INetworkProvider)tileEntity).getNetwork();
                }
            } else {
                return ((INetworkProvider)tileEntity).getNetwork();
            }
        }
        return null;
    }
}

