/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.flag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.flag.Flag;
import universalelectricity.prefab.flag.FlagBase;
import universalelectricity.prefab.flag.FlagWorld;
import universalelectricity.prefab.vector.Region3;

public class FlagRegion
extends FlagBase {
    public FlagWorld flagWorld;
    public String name;
    public Region3 region;
    private final List flags = new ArrayList();

    public FlagRegion(FlagWorld worldFlagData) {
        this.flagWorld = worldFlagData;
    }

    public FlagRegion(FlagWorld flagWorld, String name, Region3 region) {
        this.flagWorld = flagWorld;
        this.name = name;
        this.region = region;
    }

    @Override
    public void readFromNBT(bs nbt) {
        this.name = nbt.e();
        Vector3 startVector = Vector3.readFromNBT(nbt.l("min"));
        Vector3 endVector = Vector3.readFromNBT(nbt.l("max"));
        this.region = new Region3(startVector, endVector);
        ca flagList = nbt.m("flags");
        for (int i = 0; i < flagList.c(); ++i) {
            bs childNode = (bs)flagList.b(i);
            try {
                Flag flag = new Flag(this);
                flag.readFromNBT(childNode);
                this.flags.add(flag);
                continue;
            }
            catch (Exception e) {
                System.out.println("Mod Flag: Failed to read flag data: " + childNode.e());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(bs nbt) {
        nbt.p(this.name);
        nbt.a("min", (cf)this.region.min.writeToNBT(new bs()));
        nbt.a("max", (cf)this.region.max.writeToNBT(new bs()));
        ca flagList = new ca();
        for (Flag flag : this.getFlags()) {
            try {
                flagList.a((cf)flag.getNBT());
            }
            catch (Exception e) {
                System.out.println("Failed to save world flag data: " + flag.name);
                e.printStackTrace();
            }
        }
        nbt.a("flags", (cf)flagList);
    }

    public boolean containsValue(String flagName, String checkValue, Vector3 position) {
        for (Flag flag : this.flags) {
            if (!flag.name.equalsIgnoreCase(flagName) || !flag.value.equalsIgnoreCase(checkValue)) continue;
            return true;
        }
        return false;
    }

    public boolean setFlag(String flagName, String value) {
        this.removeFlag(flagName);
        if (value != null && value != "" && !this.containsFlag(flagName)) {
            return this.flags.add(new Flag(this, flagName, value));
        }
        return false;
    }

    public boolean containsFlag(String flagName) {
        for (Flag region : this.flags) {
            if (!region.name.equalsIgnoreCase(flagName)) continue;
            return true;
        }
        return false;
    }

    public boolean removeFlag(String flagName) {
        for (Flag region : this.flags) {
            if (!region.name.equalsIgnoreCase(flagName)) continue;
            this.flags.remove(region);
            return true;
        }
        return false;
    }

    public List getFlags() {
        Iterator it = this.flags.iterator();
        while (it.hasNext()) {
            Flag flag = (Flag)it.next();
            if (flag == null) {
                it.remove();
                continue;
            }
            if (flag.name != null && flag.name != "") continue;
            it.remove();
        }
        return this.flags;
    }

    public void edit(Vector3 position, int radius) {
        Vector3 minVec = new Vector3(position.intX() - radius, 0.0, position.intZ() - radius);
        Vector3 maxVec = new Vector3(position.intX() + radius, this.flagWorld.world.Q(), position.intZ() + radius);
        this.region = new Region3(minVec, maxVec);
    }
}

