/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.flag;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.DimensionManager;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.flag.FlagBase;
import universalelectricity.prefab.flag.FlagWorld;

public class ModFlag
extends FlagBase {
    private final List flagWorlds = new ArrayList();

    public ModFlag(bs nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public void readFromNBT(bs nbt) {
        for (bs dimensionCompound : nbt.c()) {
            try {
                int dimensionID = Integer.parseInt(dimensionCompound.e().replace("dim_", ""));
                iz world = DimensionManager.getWorld((int)dimensionID);
                FlagWorld flagWorld = new FlagWorld((aab)world);
                flagWorld.readFromNBT(dimensionCompound);
                this.flagWorlds.add(flagWorld);
            }
            catch (Exception e) {
                System.out.println("Mod Flag: Failed to read dimension data: " + dimensionCompound.e());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(bs nbt) {
        for (FlagWorld worldData : this.flagWorlds) {
            try {
                nbt.a("dim_" + worldData.world.t.h, (cf)worldData.getNBT());
            }
            catch (Exception e) {
                System.out.println("Mod Flag: Failed to save world flag data: " + worldData.world);
                e.printStackTrace();
            }
        }
    }

    public FlagWorld getFlagWorld(aab world) {
        FlagWorld worldData = null;
        if (world != null) {
            for (FlagWorld data : this.flagWorlds) {
                if (data.world == null || data.world.t == null || data.world.t.h != world.t.h) continue;
                worldData = data;
                break;
            }
            if (worldData == null) {
                worldData = new FlagWorld(world);
                this.flagWorlds.add(worldData);
            }
        }
        return worldData;
    }

    public boolean containsValue(aab world, String flagName, String checkValue, Vector3 position) {
        return this.getFlagWorld(world).containsValue(flagName, checkValue, position);
    }

    public List getFlagWorlds() {
        return this.flagWorlds;
    }
}

