/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import java.util.EnumSet;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.block.IElectricityStorage;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.prefab.tile.TileEntityElectrical;

public abstract class TileEntityElectricityStorage
extends TileEntityElectrical
implements IElectricityStorage {
    private double joules = 0.0;
    public double prevJoules = 0.0;

    @Override
    public void h() {
        super.h();
        this.prevJoules = this.joules;
        if (!this.k.I) {
            if (!this.isDisabled()) {
                ElectricityPack electricityPack = ElectricityNetworkHelper.consumeFromMultipleSides(this, this.getConsumingSides(), this.getRequest());
                this.onReceive(electricityPack);
            } else {
                ElectricityNetworkHelper.consumeFromMultipleSides(this, new ElectricityPack());
            }
        }
    }

    protected EnumSet getConsumingSides() {
        return ElectricityNetworkHelper.getDirections(this);
    }

    public ElectricityPack getRequest() {
        return new ElectricityPack((this.getMaxJoules() - this.getJoules()) / this.getVoltage(), this.getVoltage());
    }

    public void onReceive(ElectricityPack electricityPack) {
        if (UniversalElectricity.isVoltageSensitive && electricityPack.voltage > this.getVoltage()) {
            this.k.a(null, (double)this.l, (double)this.m, (double)this.n, 1.5f, true);
            return;
        }
        this.setJoules(this.getJoules() + electricityPack.getWatts());
    }

    public void a(bs par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.joules = par1NBTTagCompound.h("joules");
    }

    public void b(bs par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("joules", this.joules);
    }

    @Override
    public double getJoules() {
        return this.joules;
    }

    @Override
    public void setJoules(double joules) {
        this.joules = Math.max(Math.min(joules, this.getMaxJoules()), 0.0);
    }
}

