/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaksObfuscation;
import invtweaks.api.ContainerGUI;
import invtweaks.api.ContainerSection;
import invtweaks.api.InventoryGUI;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;

public class InvTweaksModCompatibility {
    private final InvTweaksObfuscation obf;

    public InvTweaksModCompatibility(InvTweaksObfuscation invTweaksObfuscation) {
        this.obf = invTweaksObfuscation;
    }

    public boolean isSpecialChest(GuiScreen guiScreen) {
        return InvTweaksModCompatibility.getContainerGUIAnnotation(guiScreen.getClass()) != null || InvTweaksModCompatibility.isExact(guiScreen, "cpw.mods.ironchest.client.GUIChest") || InvTweaksModCompatibility.isExact(guiScreen, "cubex2.mods.multipagechest.client.GuiMultiPageChest") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.machine.GuiBufferChest") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.machine.GuiRetriever") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.machine.GuiItemDetect") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.base.GuiAlloyFurnace") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.machine.GuiDeploy") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.machine.GuiSorter") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.machine.GuiFilter") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.base.GuiAdvBench") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.machine.GuiEject") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.base.GuiBag") || InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.world.GuiSeedBag") || InvTweaksModCompatibility.isExact(guiScreen, "ic2.core.block.personal.GuiPersonalChest") || InvTweaksModCompatibility.isExact(guiScreen, "ic2.core.block.generator.gui.GuiNuclearReactor") || InvTweaksModCompatibility.isExact(guiScreen, "mods.laco.colorbox.client.GuiColorBox") || InvTweaksModCompatibility.isExact(guiScreen, "shadow.mods.metallurgy.precious.FC_GuiChest") || InvTweaksModCompatibility.isExact(guiScreen, "shadow.mods.metallurgy.precious.FM_GuiMintStorage") || InvTweaksModCompatibility.isExact(guiScreen, "TFC.GUI.GuiChestTFC") || InvTweaksModCompatibility.isExact(guiScreen, "forestry.storage.gui.GuiBackpack") || InvTweaksModCompatibility.isExact(guiScreen, "forestry.storage.gui.GuiBackpackT2") || InvTweaksModCompatibility.isExact(guiScreen, "com.pahimar.ee3.client.gui.inventory.GuiPortableCrafting") || InvTweaksModCompatibility.isExact(guiScreen, "codechicken.enderstorage.storage.item.GuiEnderItemStorage") || InvTweaksModCompatibility.isExact(guiScreen, "net.mcft.copy.betterstorage.client.GuiReinforcedChest");
    }

    public int getSpecialChestRowSize(GuiContainer guiContainer, int n) {
        ContainerGUI containerGUI = InvTweaksModCompatibility.getContainerGUIAnnotation(guiContainer.getClass());
        if (containerGUI != null) {
            Method method = InvTweaksModCompatibility.getAnnotatedMethod(guiContainer.getClass(), new Class[]{ContainerGUI.RowSizeCallback.class}, 0, Integer.TYPE);
            if (method != null) {
                try {
                    return (Integer)method.invoke((Object)guiContainer, new Object[0]);
                }
                catch (Exception exception) {
                    return containerGUI.rowSize();
                }
            }
            return containerGUI.rowSize();
        }
        if (InvTweaksModCompatibility.isExact(guiContainer, "cpw.mods.ironchest.client.GUIChest")) {
            try {
                return (Integer)guiContainer.getClass().getMethod("getRowLength", new Class[0]).invoke((Object)guiContainer, new Object[0]);
            }
            catch (Exception exception) {
                return n;
            }
        }
        if (InvTweaksModCompatibility.isExact(guiContainer, "cubex2.mods.multipagechest.client.GuiMultiPageChest")) {
            return 13;
        }
        if (InvTweaksModCompatibility.isExact(guiContainer, "com.eloraam.redpower.machine.GuiBufferChest")) {
            return 4;
        }
        if (InvTweaksModCompatibility.isExact(guiContainer, "com.eloraam.redpower.machine.GuiSorter")) {
            return 8;
        }
        if (InvTweaksModCompatibility.isExact(guiContainer, "com.eloraam.redpower.machine.GuiRetriever") || InvTweaksModCompatibility.isExact(guiContainer, "com.eloraam.redpower.machine.GuiItemDetect") || InvTweaksModCompatibility.isExact(guiContainer, "com.eloraam.redpower.base.GuiAlloyFurnace") || InvTweaksModCompatibility.isExact(guiContainer, "com.eloraam.redpower.machine.GuiDeploy") || InvTweaksModCompatibility.isExact(guiContainer, "com.eloraam.redpower.machine.GuiFilter") || InvTweaksModCompatibility.isExact(guiContainer, "com.eloraam.redpower.machine.GuiEject")) {
            return 3;
        }
        if (InvTweaksModCompatibility.isExact(guiContainer, "ic2.core.block.generator.gui.GuiNuclearReactor")) {
            return (this.obf.getSlots(this.obf.getContainer(guiContainer)).size() - 36) / 6;
        }
        if (InvTweaksModCompatibility.isExact(guiContainer, "net.mcft.copy.betterstorage.client.GuiReinforcedChest")) {
            try {
                return (Integer)guiContainer.getClass().getMethod("getNumColumns", new Class[0]).invoke((Object)guiContainer, new Object[0]);
            }
            catch (Exception exception) {
                return n;
            }
        }
        return n;
    }

    public boolean isChestWayTooBig(GuiScreen guiScreen) {
        return InvTweaksModCompatibility.isExact(guiScreen, "cubex2.mods.multipagechest.client.GuiMultiPageChest") || InvTweaksModCompatibility.isExact(guiScreen, "cpw.mods.ironchest.client.GUIChest") || InvTweaksModCompatibility.isExact(guiScreen, "shadow.mods.metallurgy.precious.FC_GuiChest");
    }

    public boolean isSpecialInventory(GuiScreen guiScreen) {
        if (InvTweaksModCompatibility.getInventoryGUIAnnotation(guiScreen.getClass()) != null) {
            return true;
        }
        if (InvTweaksModCompatibility.isExact(guiScreen, "micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiTankRefill")) {
            return true;
        }
        try {
            return this.obf.getSlots(this.obf.getContainer(this.obf.asGuiContainer(guiScreen))).size() > 36 && !this.obf.isGuiInventoryCreative(guiScreen);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isStandardInventory(GuiScreen guiScreen) {
        return InvTweaksModCompatibility.isExact(guiScreen, "micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiInventory");
    }

    public Map<ContainerSection, List<Slot>> getSpecialContainerSlots(GuiScreen guiScreen, Container container) {
        Object object;
        Serializable serializable;
        if (guiScreen != null && InvTweaksModCompatibility.isAPIClass(serializable = guiScreen.getClass()) && (object = InvTweaksModCompatibility.getAnnotatedMethod(serializable, new Class[]{ContainerGUI.ContainerSectionCallback.class, InventoryGUI.ContainerSectionCallback.class}, 0, Map.class)) != null) {
            try {
                return (Map)((Method)object).invoke((Object)guiScreen, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        serializable = new HashMap();
        object = this.obf.getSlots(container);
        if (InvTweaksModCompatibility.isExact(guiScreen, "com.eloraam.redpower.base.GuiAdvBench")) {
            serializable.put(ContainerSection.CRAFTING_IN_PERSISTENT, object.subList(0, 9));
            serializable.put(ContainerSection.CRAFTING_OUT, object.subList(10, 11));
            serializable.put(ContainerSection.CHEST, object.subList(11, 29));
        } else if (InvTweaksModCompatibility.isExact(guiScreen, "thaumcraft.client.gui.GuiArcaneWorkbench") || InvTweaksModCompatibility.isExact(guiScreen, "thaumcraft.client.gui.GuiInfusionWorkbench")) {
            serializable.put(ContainerSection.CRAFTING_OUT, object.subList(0, 1));
            serializable.put(ContainerSection.CRAFTING_IN_PERSISTENT, object.subList(2, 11));
        } else if (InvTweaksModCompatibility.isExact(guiScreen, "com.pahimar.ee3.client.gui.inventory.GuiPortableCrafting")) {
            serializable.put(ContainerSection.CRAFTING_OUT, object.subList(0, 1));
            serializable.put(ContainerSection.CRAFTING_IN, object.subList(1, 10));
        } else if (InvTweaksModCompatibility.isExact(guiScreen, "micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiTankRefill")) {
            serializable.put(ContainerSection.CRAFTING_OUT, object.subList(0, 1));
            serializable.put(ContainerSection.CRAFTING_IN, object.subList(1, 5));
            serializable.put(ContainerSection.ARMOR, object.subList(5, 9));
            serializable.put(ContainerSection.INVENTORY, object.subList(9, 45));
            serializable.put(ContainerSection.INVENTORY_NOT_HOTBAR, object.subList(9, 36));
            serializable.put(ContainerSection.INVENTORY_HOTBAR, object.subList(36, 45));
        } else if (InvTweaksModCompatibility.isExact(container, "micdoodle8.mods.galacticraft.core.inventory.GCCoreContainerPlayer")) {
            serializable.put(ContainerSection.CRAFTING_OUT, object.subList(0, 1));
            serializable.put(ContainerSection.CRAFTING_IN, object.subList(1, 5));
            serializable.put(ContainerSection.ARMOR, object.subList(5, 9));
            serializable.put(ContainerSection.INVENTORY, object.subList(9, 45));
            serializable.put(ContainerSection.INVENTORY_NOT_HOTBAR, object.subList(9, 36));
            serializable.put(ContainerSection.INVENTORY_HOTBAR, object.subList(36, 45));
        }
        return serializable;
    }

    private static boolean isExact(Object object, String string) {
        try {
            return object.getClass().getName().equals(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static ContainerGUI getContainerGUIAnnotation(Class<? extends GuiScreen> clazz) {
        return clazz.getAnnotation(ContainerGUI.class);
    }

    private static InventoryGUI getInventoryGUIAnnotation(Class<? extends GuiScreen> clazz) {
        return clazz.getAnnotation(InventoryGUI.class);
    }

    private static boolean isAPIClass(Class<? extends GuiScreen> clazz) {
        return InvTweaksModCompatibility.getContainerGUIAnnotation(clazz) != null || InvTweaksModCompatibility.getInventoryGUIAnnotation(clazz) != null;
    }

    private static Method getAnnotatedMethod(Class clazz, Class[] classArray, int n, Class clazz2) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            for (Class clazz3 : classArray) {
                if (method.getAnnotation(clazz3) == null || method.getParameterTypes().length != n || !clazz2.isAssignableFrom(method.getReturnType())) continue;
                return method;
            }
        }
        return null;
    }
}

