/*
 * Decompiled with CFR 0.152.
 */
package eplus;

import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.ItemData;
import eplus.blocks.Blocks;
import eplus.commands.EplusCommands;
import eplus.handlers.ConfigurationHandler;
import eplus.handlers.LanguageHandler;
import eplus.handlers.PluginHandler;
import eplus.handlers.Version;
import eplus.inventory.TileEnchantTable;
import eplus.lib.EnchantmentHelp;
import eplus.network.ConnectionHandler;
import eplus.network.GuiHandler;
import eplus.network.PacketHandler;
import eplus.network.PlayerTracker;
import eplus.network.proxies.CommonProxy;
import eplus.plugins.EplusPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.command.ICommand;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

@Mod(name="Enchanting Plus", modid="eplus", dependencies="required-after:Forge@[7.8.0.684,)")
@NetworkMod(channels={"eplus"}, packetHandler=PacketHandler.class, connectionHandler=ConnectionHandler.class, clientSideRequired=true)
public class EnchantingPlus {
    @Mod.Instance(value="eplus")
    public static EnchantingPlus INSTANCE;
    public static Logger log;
    public static final boolean Debug;
    @SidedProxy(clientSide="eplus.network.proxies.ClientProxy", serverSide="eplus.network.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static Map<Integer, String> itemMap;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerTileEntity(TileEnchantTable.class);
        NetworkRegistry.instance().registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        GameRegistry.registerPlayerTracker((IPlayerTracker)new PlayerTracker());
        proxy.registerTickHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PluginHandler.initPlugins(event.getModState());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        Version.init(event.getVersionProperties());
        Version.check();
        event.getModMetadata().version = Version.getCurrentModVersion();
        NBTTagList list = new NBTTagList();
        GameData.writeItemData((NBTTagList)list);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemData itemData = new ItemData((NBTTagCompound)list.func_74743_b(i));
            itemMap.put(itemData.getItemId(), itemData.getModId());
        }
        PluginHandler.init(event.getAsmData().getAll(EplusPlugin.class.getCanonicalName()));
        PluginHandler.initPlugins(event.getModState());
        try {
            LanguageHandler.getInstance().addLanguages("/assets/eplus/lang/langs.txt");
        }
        catch (NullPointerException e) {
            log.severe(String.format("Can not load %s", "/assets/eplus/lang/langs.txt"));
        }
        LanguageHandler.getInstance().loadLangauges();
        Blocks.init();
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            String name;
            NBTTagCompound nbtBase;
            int i;
            NBTTagList enchantments;
            NBTTagCompound nbtValue;
            if (imcMessage.key.equalsIgnoreCase("enchant-tooltip")) {
                if (imcMessage.isStringMessage()) {
                    String[] strings = imcMessage.getStringValue().split(":");
                    if (!EnchantmentHelp.putToolTips(strings[0], strings[1])) continue;
                    log.info(String.format("Add custom enchantment tool-tip for %s. Request sent from %s", strings[0], imcMessage.getSender()));
                    continue;
                }
                if (imcMessage.isNBTMessage()) {
                    nbtValue = imcMessage.getNBTValue();
                    enchantments = nbtValue.func_74761_m("Enchantments");
                    for (i = 0; i < enchantments.func_74745_c(); ++i) {
                        String description;
                        nbtBase = (NBTTagCompound)enchantments.func_74743_b(i);
                        name = nbtBase.func_74779_i("Name");
                        if (!EnchantmentHelp.putToolTips(name, description = nbtBase.func_74779_i("Description"))) continue;
                        log.info(String.format("Add custom enchantment tool-tip for %s. Request sent from %s", name, imcMessage.getSender()));
                    }
                    continue;
                }
                log.warning(String.format("Invalid IMC Message from %s", imcMessage.getSender()));
                continue;
            }
            if (imcMessage.key.equalsIgnoreCase("blacklist-enchantment")) {
                if (imcMessage.isStringMessage()) {
                    String string = imcMessage.getStringValue();
                    if (!EnchantmentHelp.putBlackList(string)) continue;
                    log.info(String.format("Add custom enchantment blacklist for %s. Request sent from %s", string, imcMessage.getSender()));
                    continue;
                }
                if (imcMessage.isNBTMessage()) {
                    nbtValue = imcMessage.getNBTValue();
                    enchantments = nbtValue.func_74761_m("Enchantments");
                    for (i = 0; i < enchantments.func_74745_c(); ++i) {
                        nbtBase = (NBTTagCompound)enchantments.func_74743_b(i);
                        name = nbtBase.func_74779_i("Name");
                        if (!EnchantmentHelp.putBlackList(name)) continue;
                        log.info(String.format("Add custom enchantment blacklist for %s. Request sent from %s", name, imcMessage.getSender()));
                    }
                    continue;
                }
                log.warning(String.format("Invalid IMC Message from %s", imcMessage.getSender()));
                continue;
            }
            if (!imcMessage.key.equalsIgnoreCase("blacklist-item")) continue;
            if (imcMessage.isStringMessage()) {
                Integer itemId = Integer.valueOf(imcMessage.getStringValue());
                if (!EnchantmentHelp.putBlackListItem(itemId)) continue;
                log.info(String.format("Add custom item blacklist for item id %d. Request sent from %s", itemId, imcMessage.getSender()));
                continue;
            }
            if (imcMessage.isNBTMessage()) {
                nbtValue = imcMessage.getNBTValue();
                enchantments = nbtValue.func_74761_m("items");
                for (i = 0; i < enchantments.func_74745_c(); ++i) {
                    nbtBase = (NBTTagCompound)enchantments.func_74743_b(i);
                    Integer itemId = Integer.valueOf(nbtBase.func_74779_i("itemId"));
                    if (!EnchantmentHelp.putBlackListItem(itemId)) continue;
                    log.info(String.format("Add custom item blacklist for item id %d. Request sent from %s", itemId, imcMessage.getSender()));
                }
                continue;
            }
            log.warning(String.format("Invalid IMC Message from %s", imcMessage.getSender()));
        }
    }

    private void registerTileEntity(Class<? extends TileEntity> tileEntity) {
        GameRegistry.registerTileEntity(tileEntity, (String)("eplus:" + tileEntity.getSimpleName()));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new EplusCommands());
    }

    static {
        Debug = Boolean.parseBoolean(System.getenv("DEBUG"));
        itemMap = new HashMap<Integer, String>();
    }
}

