/*
 * Decompiled with CFR 0.152.
 */
package walkingdead.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import walkingdead.common.EntityWalkingDead;
import walkingdead.common.WalkingDead;

public final class SpawnerWalkingDead {
    private static HashMap eligibleChunksForSpawning = new HashMap();

    protected static ChunkPosition getRandomSpawningPointInChunk(World world, int x, int z) {
        Chunk chunk = world.func_72964_e(x, z);
        int newX = x * 16 + world.field_73012_v.nextInt(16);
        int newY = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1);
        int newZ = z * 16 + world.field_73012_v.nextInt(16);
        return new ChunkPosition(newX, newY, newZ);
    }

    public static final int SpawnWalkers(WorldServer worldServer) {
        eligibleChunksForSpawning.clear();
        for (int entities = 0; entities < worldServer.field_73010_i.size(); ++entities) {
            EntityPlayer entityPlayer = (EntityPlayer)worldServer.field_73010_i.get(entities);
            int playerX = MathHelper.func_76128_c((double)(entityPlayer.field_70165_t / 16.0));
            int playerZ = MathHelper.func_76128_c((double)(entityPlayer.field_70161_v / 16.0));
            int range = 8;
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    boolean inRange = x == -range || x == range || z == -range || z == range;
                    ChunkCoordIntPair chunkCoord = new ChunkCoordIntPair(x + playerX, z + playerZ);
                    if (!inRange) {
                        eligibleChunksForSpawning.put(chunkCoord, false);
                        continue;
                    }
                    if (eligibleChunksForSpawning.containsKey(chunkCoord)) continue;
                    eligibleChunksForSpawning.put(chunkCoord, true);
                }
            }
        }
        int eligibleChunks = 0;
        ChunkCoordinates spawnPoint = worldServer.func_72861_E();
        EnumCreatureType creatureType = EnumCreatureType.monster;
        int walkerSpawns = WalkingDead.instance.getWalkerSpawns();
        if (worldServer.func_72907_a(EntityWalkingDead.class) < walkerSpawns) {
            Iterator iter = eligibleChunksForSpawning.keySet().iterator();
            ArrayList tmp = new ArrayList(eligibleChunksForSpawning.keySet());
            Collections.shuffle(tmp);
            for (ChunkCoordIntPair chunkPair : tmp) {
                if (((Boolean)eligibleChunksForSpawning.get(chunkPair)).booleanValue()) continue;
                ChunkPosition chunkPos = SpawnerWalkingDead.getRandomSpawningPointInChunk((World)worldServer, chunkPair.field_77276_a, chunkPair.field_77275_b);
                boolean normalBlock = worldServer.func_72809_s(chunkPos.field_76930_a, chunkPos.field_76928_b, chunkPos.field_76929_c);
                Material material = worldServer.func_72803_f(chunkPos.field_76930_a, chunkPos.field_76928_b, chunkPos.field_76929_c);
                if (normalBlock || material != creatureType.func_75600_c()) continue;
                int nSpawned = 0;
                for (int spawnCount = 0; spawnCount < 3; ++spawnCount) {
                    int newX = chunkPos.field_76930_a;
                    int newY = chunkPos.field_76928_b;
                    int newZ = chunkPos.field_76929_c;
                    int chunkRange = 6;
                    for (int spawnAttempts = 0; spawnAttempts < 4; ++spawnAttempts) {
                        float deltaZ;
                        float deltaY;
                        float deltaX;
                        float distance;
                        float adjZ;
                        float adjY;
                        float adjX;
                        if (!SpawnerWalkingDead.canCreatureTypeSpawnAtLocation(creatureType, (World)worldServer, newX += worldServer.field_73012_v.nextInt(6) - worldServer.field_73012_v.nextInt(6), newY += worldServer.field_73012_v.nextInt(1) - worldServer.field_73012_v.nextInt(1), newZ += worldServer.field_73012_v.nextInt(6) - worldServer.field_73012_v.nextInt(6)) || worldServer.func_72977_a((double)(adjX = (float)newX + 0.5f), (double)(adjY = (float)newY), (double)(adjZ = (float)newZ + 0.5f), 12.0) != null || !((distance = MathHelper.func_76129_c((float)((deltaX = adjX - (float)spawnPoint.field_71574_a) * deltaX + (deltaY = adjY - (float)spawnPoint.field_71572_b) * deltaY + (deltaZ = adjZ - (float)spawnPoint.field_71573_c) * deltaZ))) >= 16.0f)) continue;
                        EntityWalkingDead walker = new EntityWalkingDead((World)worldServer);
                        walker.func_70012_b(adjX, adjY, adjZ, worldServer.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (walker.func_70601_bi() && nSpawned < walker.func_70641_bl()) {
                            ++nSpawned;
                            worldServer.func_72838_d((Entity)walker);
                            walker.func_82163_bD();
                        }
                        eligibleChunks += nSpawned;
                    }
                }
            }
        }
        return eligibleChunks;
    }

    public static boolean canCreatureTypeSpawnAtLocation(EnumCreatureType creatureType, World world, int x, int y, int z) {
        if (!world.func_72797_t(x, y - 1, z)) {
            return false;
        }
        int blockID = world.func_72798_a(x, y - 1, z);
        boolean spawnBlock = Block.field_71973_m[blockID] != null && Block.field_71973_m[blockID].canCreatureSpawn(creatureType, world, x, y - 1, z);
        return spawnBlock && blockID != Block.field_71986_z.field_71990_ca && !world.func_72809_s(x, y, z) && !world.func_72803_f(x, y, z).func_76224_d() && !world.func_72809_s(x, y + 1, z);
    }

    public static int despawnWalker(WorldServer worldObj, Class cls) {
        int count = 0;
        for (int j = 0; j < worldObj.field_72996_f.size(); ++j) {
            Entity entity = (Entity)worldObj.field_72996_f.get(j);
            if (!(entity instanceof EntityWalkingDead)) continue;
            count += SpawnerWalkingDead.entityDespawnCheck(worldObj, (EntityLiving)entity);
        }
        return count;
    }

    protected static int entityDespawnCheck(WorldServer worldObj, EntityLiving entity) {
        EntityPlayer entityplayer = worldObj.func_72890_a((Entity)entity, -1.0);
        if (entityplayer != null) {
            double deltaX = entityplayer.field_70165_t - entity.field_70165_t;
            double deltaY = entityplayer.field_70163_u - entity.field_70163_u;
            double deltaZ = entityplayer.field_70161_v - entity.field_70161_v;
            double distance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
            if (distance > 128.0) {
                entity.func_70106_y();
                return 1;
            }
            int age = entity.func_70654_ax();
            if (age > 600 && worldObj.field_73012_v.nextInt(800) == 0 && distance > 32.0) {
                entity.func_70106_y();
                return 1;
            }
        }
        return 0;
    }
}

