/*
 * Decompiled with CFR 0.152.
 */
package walkingdead.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.LinkedList;
import java.util.logging.Logger;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenEnd;
import net.minecraft.world.biome.BiomeGenHell;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DungeonHooks;
import walkingdead.common.CommonProxyWalkingDead;
import walkingdead.common.EntityWalkingDead;

@Mod(modid="WalkingDeadMod", name="WalkingDead Mod", version="1.5.2")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, versionBounds="[1.5.2]")
public class WalkingDead {
    @Mod.Instance
    public static WalkingDead instance;
    public static final String version = "1.5.2";
    public static final String modid = "WalkingDeadMod";
    public static final String name = "WalkingDead Mod";
    private int walkerSpawnProb;
    private int walkerSpawns;
    private boolean spawnCreepers;
    private boolean spawnZombies;
    private boolean spawnSkeletons;
    private boolean spawnEnderman;
    private boolean spawnSpiders;
    private boolean spawnSlime;
    private boolean randomSkins;
    private boolean doorBusting;
    private Logger logger;
    @SidedProxy(clientSide="walkingdead.client.ClientProxyWalkingDead", serverSide="walkingdead.common.CommonProxyWalkingDead")
    public static CommonProxyWalkingDead proxy;

    public String getVersion() {
        return version;
    }

    @Mod.PreInit
    public void preLoad(FMLPreInitializationEvent event) {
        this.logger = Logger.getLogger(modid);
        this.logger.setParent(FMLLog.getLogger());
        String generalComments = "WalkingDead Mod Config\nMichael Sheppard (crackedEgg)\n";
        String spawnProbComment = "walkerSpawnProb adjust to probability of walkers spawning,\nalthough the custom spawning most likely overrides this. the higher the\nthe number the more likely walkers will spawn.";
        String walkerComment = "walkerSpawns adjusts the number of walkers spawned, play\nwith it to see what you like. The higher the number the more\nwalkers will spawn.";
        String creeperComment = "creeperSpawns, set to false to disable creeper spawning, set to true\nif you want to spawn creepers";
        String skeletonComment = "skeletonSpawns, set to false to disable skeleton spawning, set to true\nif you want to spawn skeletons";
        String zombieComment = "zombieSpawns, set to false to disable zombie spawning, set to true\nif you want to spawn zombies. Note that spawning zombies and other monsters\nwill cause the number of walkers spawned to be reduced.";
        String endermanComment = "endermanSpawns, set to false to disable enderman spawning, set to true\nif you want to spawn enderman";
        String spiderComment = "spiderSpawns, set to false to disable spider spawning, set to true\nif you want to spawn spiders";
        String slimeComment = "slimeSpawns, set to false to disable slime spawning, set to true\nif you want to spawn slimes";
        String randomSkinsComment = "randomSkins, set to true to use the internal random skins in the mod\njar. Set to false to use your texture pack random mobs.";
        String doorBustingComment = "doorBusting, set to true to have walkers try to break down doors,\notherwise set to false. It's quieter.";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.walkerSpawnProb = config.get("general", "walkerSpawnProb", 10, spawnProbComment).getInt();
        this.walkerSpawns = config.get("general", "walkerSpawns", 60, walkerComment).getInt();
        this.spawnCreepers = config.get("general", "spawnCreepers", false, creeperComment).getBoolean(false);
        this.spawnSkeletons = config.get("general", "spawnSkeletons", false, skeletonComment).getBoolean(false);
        this.spawnZombies = config.get("general", "spawnZombies", false, zombieComment).getBoolean(false);
        this.spawnEnderman = config.get("general", "spawnEnderman", false, endermanComment).getBoolean(false);
        this.spawnSpiders = config.get("general", "spawnSpiders", true, spiderComment).getBoolean(false);
        this.spawnSlime = config.get("general", "spawnSlime", false, slimeComment).getBoolean(false);
        this.randomSkins = config.get("general", "randomSkins", false, randomSkinsComment).getBoolean(false);
        this.doorBusting = config.get("general", "doorBusting", false, doorBustingComment).getBoolean(false);
        config.addCustomCategoryComment("general", generalComments);
        config.save();
        proxy.registerRenderers();
        proxy.registerServerTickHandler();
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        int id = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityWalkingDead.class, (String)"WalkingDead", (int)id);
        EntityList.field_75627_a.put(id, new EntityEggInfo(id, 44975, 7969861));
        LanguageRegistry.instance().addStringLocalization("entity.WalkingDead.name", "Walker");
        this.logger.info("*** Scanning for available biomes");
        BiomeGenBase[] biomes = this.getBiomeList();
        EntityRegistry.addSpawn(EntityWalkingDead.class, (int)this.walkerSpawnProb, (int)2, (int)10, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
        DungeonHooks.addDungeonMob((String)"WalkingDead", (int)200);
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Item.field_77716_q), 1, 1, 4));
        if (!this.spawnCreepers) {
            EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            this.logger.info("*** Removing creeper spawns");
        }
        if (!this.spawnSkeletons) {
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            this.logger.info("*** Removing skeleton spawns");
        }
        if (!this.spawnZombies) {
            EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            this.logger.info("*** Removing zombie spawns");
        }
        if (!this.spawnEnderman) {
            EntityRegistry.removeSpawn(EntityEnderman.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            this.logger.info("*** Removing enderman spawns");
        }
        if (!this.spawnSpiders) {
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            this.logger.info("*** Removing spider spawns");
        }
        if (!this.spawnSlime) {
            EntityRegistry.removeSpawn(EntitySlime.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            this.logger.info("*** Removing slime spawns");
        }
    }

    public BiomeGenBase[] getBiomeList() {
        LinkedList<BiomeGenBase> linkedlist = new LinkedList<BiomeGenBase>();
        for (BiomeGenBase biomegenbase : BiomeGenBase.field_76773_a) {
            if (biomegenbase == null || biomegenbase instanceof BiomeGenHell || biomegenbase instanceof BiomeGenEnd || biomegenbase instanceof BiomeGenOcean) continue;
            this.logger.info(" >>> Adding " + biomegenbase.field_76791_y + " for spawning");
            linkedlist.add(biomegenbase);
        }
        return linkedlist.toArray(new BiomeGenBase[0]);
    }

    public int getWalkerSpawns() {
        return this.walkerSpawns;
    }

    public boolean getRandomSkins() {
        return this.randomSkins;
    }

    public boolean getDoorBusting() {
        return this.doorBusting;
    }
}

