/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer;

import com.sijobe.installer.ActionHandler;
import com.sijobe.installer.FooterLink;
import com.sijobe.installer.InstallOutputStream;
import com.sijobe.installer.Util;
import com.sijobe.swing.JHyperLink;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class GuiMain {
    public static final int LOGGING_LEVEL = 2;
    public static final String FONT_FACE_DEFAULT = "Tahoma";
    public static final int FONT_SIZE_BODY = 16;
    public static final int FONT_SIZE_FOOTER = 9;
    public static final int FRAME_WIDTH = 525;
    public static final int FRAME_HEIGHT = 400;
    public static final String SUPPORT_URL = "http://bit.ly/spcmod";
    JFrame frameModInstaller;
    private JTextField textFieldFilepath;
    private JFileChooser filechooser;
    private JLabel labelInstalling;
    private JButton buttonInstall;
    private JLabel labelOutput;
    private JCheckBox checkboxBackupWorlds;
    private JCheckBox checkboxBackupMinecraftjar;
    private JButton buttonStartMinecraft;
    private JButton advancedButton;
    private static JTextArea TEXTAREA_ADVANCED = new JTextArea();
    private JScrollPane scrollPane;
    private JButton buttonBrowse;
    private boolean installed;
    private ActionHandler n;
    public final String PROJECT;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    GuiMain window = new GuiMain();
                    window.frameModInstaller.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public GuiMain() {
        try {
            System.setOut(new InstallOutputStream((OutputStream)System.out, 2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.n = new ActionHandler(this);
        if (this.n.manifest.getProjectNames().length < 1) {
            System.err.println("The manifest contained within this installer is either missing, corrupt or doesn't contain any projects.");
            System.exit(1);
        }
        this.PROJECT = this.n.manifest.getProjectNames()[0];
        this.initialize();
        System.out.println("GUI initialised");
    }

    public static void log(String message) {
        TEXTAREA_ADVANCED.append(String.valueOf(message) + "\n");
        TEXTAREA_ADVANCED.setCaretPosition(TEXTAREA_ADVANCED.getText().length());
    }

    public void sendError(String message) {
        this.labelOutput.setForeground(new Color(255, 0, 0));
        this.labelOutput.setText(message);
        this.installed = false;
    }

    public void sendSuccessMessage(String message) {
        this.labelOutput.setForeground(new Color(0, 128, 0));
        this.labelOutput.setText(message);
        this.installed = true;
    }

    public void installMod(boolean install) {
        if (install) {
            int n;
            String output = null;
            output = this.checkMinecraftVersion();
            if (output != null && (n = JOptionPane.showConfirmDialog(this.frameModInstaller, String.valueOf(output) + "\n\nDo you want to continue installation?", "Version Inconsistency", 0, 2)) == 1) {
                return;
            }
            this.checkboxBackupWorlds.setEnabled(false);
            this.checkboxBackupMinecraftjar.setEnabled(false);
            this.buttonBrowse.setEnabled(false);
            this.buttonInstall.setVisible(false);
            this.labelInstalling.setVisible(true);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        GuiMain.this.n.install(GuiMain.this.PROJECT, ((GuiMain)GuiMain.this).n.files, Util.INSTALLBASE, new File(GuiMain.this.textFieldFilepath.getText()), ((GuiMain)GuiMain.this).n.manifest, GuiMain.this.checkboxBackupMinecraftjar.isSelected(), GuiMain.this.checkboxBackupWorlds.isSelected());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        } else {
            this.labelInstalling.setVisible(false);
            if (this.installed) {
                this.buttonStartMinecraft.setVisible(true);
            } else {
                this.checkboxBackupWorlds.setEnabled(true);
                this.checkboxBackupMinecraftjar.setEnabled(true);
                this.buttonBrowse.setEnabled(true);
                this.buttonInstall.setVisible(true);
            }
        }
    }

    public void browseButtonAction() {
        this.filechooser.setFileSelectionMode(1);
        this.filechooser.setSelectedFile(new File(this.textFieldFilepath.getText()));
        int returnVal = this.filechooser.showOpenDialog(null);
        if (returnVal == 0) {
            int n;
            File file = this.filechooser.getSelectedFile();
            this.textFieldFilepath.setText(file.getAbsolutePath());
            String output = null;
            output = this.checkMinecraftVersion();
            if (output != null && (n = JOptionPane.showConfirmDialog(this.frameModInstaller, String.valueOf(output) + "\n\nDo you want to select another location?", "Version Inconsistency", 0, 2)) == 0) {
                this.browseButtonAction();
            }
        }
    }

    public String checkMinecraftVersion() {
        String mcversion = Util.getMinecraftVersion(this.textFieldFilepath.getText());
        String[] versions = this.n.manifest.getMinecraftVersions(this.PROJECT);
        String verstr = "";
        int i = 0;
        while (i < versions.length) {
            if (mcversion != null && mcversion.equalsIgnoreCase(versions[i])) {
                System.out.println("INFO: Appears to be correct Minecraft (" + mcversion + ") and mod versions (" + versions[i] + ").");
                return null;
            }
            verstr = String.valueOf(verstr) + versions[i] + ", ";
            ++i;
        }
        verstr = verstr.endsWith(", ") ? verstr.substring(0, verstr.length() - 2) : verstr;
        String message = null;
        if (versions != null && versions.length != 0) {
            message = mcversion == null ? "Couldn't detect your current Minecraft version, this could be due to Minecraft.jar not existing at the specified destination, if you're using an old version of Minecraft or an internal error occurred.\n\nThis mod supports the following versions: " + verstr + ". " : "Your current Minecraft version was detected as " + mcversion + ". " + "\nThis mod supports the following versions: " + verstr + ". If you continue to install the mod to this " + "destination it may not work as expected.";
        }
        message = null;
        return message;
    }

    private void initialize() {
        try {
            try {
                UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
                int i = 0;
                while (i < info.length) {
                    if ("Nimbus".equals(info[i].getName())) {
                        UIManager.setLookAndFeel(info[i].getClassName());
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.filechooser = new JFileChooser();
        this.frameModInstaller = new JFrame();
        this.frameModInstaller.setResizable(false);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sijobe.installer.GuiMain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.frameModInstaller.setIconImage(toolkit.getImage(clazz.getResource("/com/sijobe/images/icon.png")));
        this.frameModInstaller.setTitle(String.valueOf(this.PROJECT) + " -  Installation");
        this.frameModInstaller.setBounds(100, 100, 525, 400);
        this.frameModInstaller.setDefaultCloseOperation(3);
        this.frameModInstaller.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panelTop = new JPanel();
        panelTop.setSize(new Dimension(525, 100));
        FlowLayout flowLayout = (FlowLayout)panelTop.getLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        panelTop.setAlignmentY(0.0f);
        panelTop.setAlignmentX(0.0f);
        panelTop.setBorder(null);
        this.frameModInstaller.getContentPane().add((Component)panelTop, "North");
        JLabel labelBanner = new JLabel("");
        labelBanner.setSize(new Dimension(520, 100));
        labelBanner.setVerticalTextPosition(1);
        labelBanner.setVerticalAlignment(1);
        labelBanner.setBorder(null);
        labelBanner.setAlignmentY(0.0f);
        labelBanner.setToolTipText(this.PROJECT);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.sijobe.installer.GuiMain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        labelBanner.setIcon(new ImageIcon(clazz2.getResource("/com/sijobe/images/warning.png")));
        File tmp = null;
        BufferedImage bi = null;
        try {
            tmp = Util.getFile(this.n.manifest.getBanner(this.PROJECT), this.n.files);
            if (tmp != null) {
                try {
                    bi = Util.scale(ImageIO.read(tmp), 525, 100);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bi != null) {
                labelBanner.setIcon(new ImageIcon(bi));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        panelTop.add(labelBanner);
        JPanel panelMiddle = new JPanel();
        this.frameModInstaller.getContentPane().add((Component)panelMiddle, "Center");
        GridBagLayout gbl_panelMiddle = new GridBagLayout();
        int[] nArray = new int[7];
        nArray[0] = 160;
        nArray[1] = 59;
        nArray[3] = 32;
        nArray[4] = 33;
        nArray[5] = 36;
        nArray[6] = 73;
        gbl_panelMiddle.columnWidths = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 54;
        nArray2[1] = 26;
        nArray2[2] = 49;
        nArray2[3] = 25;
        nArray2[4] = 25;
        gbl_panelMiddle.rowHeights = nArray2;
        gbl_panelMiddle.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        gbl_panelMiddle.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panelMiddle.setLayout(gbl_panelMiddle);
        this.labelOutput = new JLabel("");
        this.labelOutput.setFont(new Font(FONT_FACE_DEFAULT, 0, 16));
        GridBagConstraints gbc_labelOutput = new GridBagConstraints();
        gbc_labelOutput.gridwidth = 7;
        gbc_labelOutput.insets = new Insets(0, 0, 5, 0);
        gbc_labelOutput.gridx = 0;
        gbc_labelOutput.gridy = 0;
        panelMiddle.add((Component)this.labelOutput, gbc_labelOutput);
        JTextArea labelDescription = new JTextArea(this.n.manifest.getDescription(this.PROJECT));
        labelDescription.setBorder(null);
        labelDescription.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        labelDescription.setWrapStyleWord(true);
        labelDescription.setColumns(35);
        labelDescription.setTabSize(3);
        labelDescription.setLineWrap(true);
        labelDescription.setBackground(new Color(0, 0, 0, 0));
        labelDescription.setEditable(false);
        labelDescription.setFont(new Font(FONT_FACE_DEFAULT, 0, 16));
        GridBagConstraints gbc_labelDescription = new GridBagConstraints();
        gbc_labelDescription.anchor = 18;
        gbc_labelDescription.gridwidth = 7;
        gbc_labelDescription.insets = new Insets(0, 0, 5, 0);
        gbc_labelDescription.gridx = 0;
        gbc_labelDescription.gridy = 1;
        panelMiddle.add((Component)labelDescription, gbc_labelDescription);
        String mcdir = "";
        if (Util.getMinecraftDir() != null) {
            mcdir = Util.getMinecraftDir().getAbsolutePath();
        }
        this.textFieldFilepath = new JTextField();
        this.textFieldFilepath.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                GuiMain.this.browseButtonAction();
            }
        });
        this.textFieldFilepath.setPreferredSize(new Dimension(370, 40));
        this.textFieldFilepath.setMinimumSize(new Dimension(380, 40));
        this.textFieldFilepath.setEditable(false);
        this.textFieldFilepath.setHorizontalAlignment(4);
        this.textFieldFilepath.setFont(new Font(FONT_FACE_DEFAULT, 0, 16));
        GridBagConstraints gbc_textFieldFilepath = new GridBagConstraints();
        gbc_textFieldFilepath.fill = 2;
        gbc_textFieldFilepath.anchor = 17;
        gbc_textFieldFilepath.gridwidth = 5;
        gbc_textFieldFilepath.gridx = 0;
        gbc_textFieldFilepath.gridy = 2;
        panelMiddle.add((Component)this.textFieldFilepath, gbc_textFieldFilepath);
        this.textFieldFilepath.setColumns(26);
        this.textFieldFilepath.setText(mcdir);
        this.buttonBrowse = new JButton("Browse");
        this.buttonBrowse.setHorizontalAlignment(4);
        this.buttonBrowse.setFont(new Font(FONT_FACE_DEFAULT, 0, 16));
        this.buttonBrowse.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg) {
                GuiMain.this.browseButtonAction();
            }
        });
        GridBagConstraints gbc_buttonBrowse = new GridBagConstraints();
        gbc_buttonBrowse.anchor = 13;
        gbc_buttonBrowse.gridwidth = 2;
        gbc_buttonBrowse.insets = new Insets(0, 0, 5, 0);
        gbc_buttonBrowse.gridx = 5;
        gbc_buttonBrowse.gridy = 2;
        panelMiddle.add((Component)this.buttonBrowse, gbc_buttonBrowse);
        this.checkboxBackupMinecraftjar = new JCheckBox("Backup Minecraft.jar");
        this.checkboxBackupMinecraftjar.setSelected(true);
        this.checkboxBackupMinecraftjar.setFont(new Font(FONT_FACE_DEFAULT, 0, 16));
        GridBagConstraints gbc_checkboxBackupMinecraftjar = new GridBagConstraints();
        gbc_checkboxBackupMinecraftjar.anchor = 17;
        gbc_checkboxBackupMinecraftjar.insets = new Insets(0, 0, 5, 5);
        gbc_checkboxBackupMinecraftjar.gridx = 0;
        gbc_checkboxBackupMinecraftjar.gridy = 3;
        panelMiddle.add((Component)this.checkboxBackupMinecraftjar, gbc_checkboxBackupMinecraftjar);
        this.checkboxBackupWorlds = new JCheckBox("Backup Worlds");
        this.checkboxBackupWorlds.setFont(new Font(FONT_FACE_DEFAULT, 0, 16));
        GridBagConstraints gbc_checkboxBackupWorlds = new GridBagConstraints();
        gbc_checkboxBackupWorlds.insets = new Insets(0, 0, 5, 5);
        gbc_checkboxBackupWorlds.anchor = 17;
        gbc_checkboxBackupWorlds.gridx = 0;
        gbc_checkboxBackupWorlds.gridy = 4;
        panelMiddle.add((Component)this.checkboxBackupWorlds, gbc_checkboxBackupWorlds);
        this.buttonInstall = new JButton("Install Version " + this.n.manifest.getVersion(this.PROJECT));
        this.buttonInstall.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                GuiMain.this.installMod(true);
            }
        });
        this.buttonInstall.setHorizontalAlignment(4);
        this.buttonInstall.setFont(new Font(FONT_FACE_DEFAULT, 0, 16));
        GridBagConstraints gbc_buttonInstall = new GridBagConstraints();
        gbc_buttonInstall.insets = new Insets(0, 0, 5, 0);
        gbc_buttonInstall.anchor = 13;
        gbc_buttonInstall.gridwidth = 5;
        gbc_buttonInstall.gridheight = 2;
        gbc_buttonInstall.gridx = 2;
        gbc_buttonInstall.gridy = 3;
        panelMiddle.add((Component)this.buttonInstall, gbc_buttonInstall);
        this.labelInstalling = new JLabel("");
        this.labelInstalling.setHorizontalAlignment(0);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("com.sijobe.installer.GuiMain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.labelInstalling.setIcon(new ImageIcon(clazz3.getResource("/com/sijobe/images/loading.gif")));
        this.labelInstalling.setVisible(false);
        GridBagConstraints gbc_labelInstalling = new GridBagConstraints();
        gbc_labelInstalling.insets = new Insets(0, 0, 5, 0);
        gbc_labelInstalling.anchor = 13;
        gbc_labelInstalling.gridwidth = 5;
        gbc_labelInstalling.gridheight = 2;
        gbc_labelInstalling.gridx = 2;
        gbc_labelInstalling.gridy = 3;
        panelMiddle.add((Component)this.labelInstalling, gbc_labelInstalling);
        this.buttonStartMinecraft = new JButton("Start Minecraft");
        this.buttonStartMinecraft.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                GuiMain.this.n.startMinecraft(new File(GuiMain.this.textFieldFilepath.getText()));
            }
        });
        this.buttonStartMinecraft.setHorizontalAlignment(4);
        this.buttonStartMinecraft.setFont(new Font(FONT_FACE_DEFAULT, 0, 16));
        this.buttonStartMinecraft.setVisible(false);
        GridBagConstraints gbc_buttonStartMinecraft = new GridBagConstraints();
        gbc_buttonStartMinecraft.insets = new Insets(0, 0, 5, 0);
        gbc_buttonStartMinecraft.anchor = 13;
        gbc_buttonStartMinecraft.gridwidth = 5;
        gbc_buttonStartMinecraft.gridheight = 2;
        gbc_buttonStartMinecraft.gridx = 2;
        gbc_buttonStartMinecraft.gridy = 3;
        panelMiddle.add((Component)this.buttonStartMinecraft, gbc_buttonStartMinecraft);
        TEXTAREA_ADVANCED.setMargin(new Insets(0, 0, 0, 0));
        TEXTAREA_ADVANCED.setFont(new Font("Monospaced", 0, 11));
        TEXTAREA_ADVANCED.setBorder(null);
        TEXTAREA_ADVANCED.setAlignmentY(0.0f);
        TEXTAREA_ADVANCED.setAlignmentX(0.0f);
        this.scrollPane = new JScrollPane(TEXTAREA_ADVANCED);
        this.scrollPane.setVisible(false);
        TEXTAREA_ADVANCED.setEditable(false);
        GridBagConstraints gbc_textAreaAdvanced = new GridBagConstraints();
        gbc_textAreaAdvanced.gridheight = 2;
        gbc_textAreaAdvanced.insets = new Insets(0, 0, 5, 0);
        gbc_textAreaAdvanced.gridwidth = 7;
        gbc_textAreaAdvanced.fill = 1;
        gbc_textAreaAdvanced.gridx = 0;
        gbc_textAreaAdvanced.gridy = 5;
        panelMiddle.add((Component)this.scrollPane, gbc_textAreaAdvanced);
        JPanel panelBottom = new JPanel();
        panelBottom.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.frameModInstaller.getContentPane().add((Component)panelBottom, "South");
        panelBottom.setLayout(new GridLayout(1, 0, 1, 0));
        List links = this.n.manifest.getFooterLinks(this.PROJECT);
        int i = 0;
        while (i < links.size() && i < 4) {
            FooterLink link = (FooterLink)links.get(i);
            if (link != null) {
                System.out.println("DEBUG: Adding link " + link.getName() + " - " + link.getValue());
                JLabel hyperLink = null;
                if (link.getValue().startsWith("http://")) {
                    try {
                        hyperLink = new JHyperLink(link.getName(), new URI(link.getValue()));
                    }
                    catch (Exception exception) {}
                } else {
                    hyperLink = new JHyperLink(link.getName(), Util.getFile(link.getValue(), this.n.files));
                }
                if (hyperLink != null) {
                    hyperLink.setHorizontalAlignment(0);
                    panelBottom.add(hyperLink);
                }
            }
            ++i;
        }
        this.advancedButton = new JButton("Advanced >");
        this.advancedButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg) {
                if (GuiMain.this.advancedButton.getText().contains(">")) {
                    GuiMain.this.advancedButton.setText("< Advanced");
                    GuiMain.this.frameModInstaller.setSize(525, 500);
                    GuiMain.this.scrollPane.setVisible(true);
                } else {
                    GuiMain.this.advancedButton.setText("Advanced >");
                    GuiMain.this.frameModInstaller.setSize(525, 400);
                    GuiMain.this.scrollPane.setVisible(false);
                }
            }
        });
        this.advancedButton.setPreferredSize(new Dimension(25, 15));
        this.advancedButton.setFont(new Font(FONT_FACE_DEFAULT, 0, 9));
        panelBottom.add(this.advancedButton);
        JPanel panelLeft = new JPanel();
        this.frameModInstaller.getContentPane().add((Component)panelLeft, "West");
        JPanel panelRight = new JPanel();
        this.frameModInstaller.getContentPane().add((Component)panelRight, "East");
    }
}

