/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer;

import com.sijobe.installer.Util;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;

public class ThreadBackupWorlds
extends Thread {
    private File mcdir;
    private Method callback;

    public ThreadBackupWorlds(File mcdir) {
        this.mcdir = mcdir;
    }

    public void setCallback(Method callback) {
        this.callback = callback;
    }

    private void signalDone(String err) {
        if (this.callback != null) {
            try {
                this.callback.invoke(null, err);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String backupWorlds(File mcdir) {
        if (mcdir == null || !mcdir.exists()) {
            return "Couldn't discover Minecraft home directory.";
        }
        File saves = new File(mcdir, "saves");
        if (!saves.exists()) {
            return "Couldn't find Minecraft.jar";
        }
        File destination = new File(mcdir, "backup/saves");
        try {
            destination.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!destination.exists()) {
            return "Couldn't create destination directory for backup.";
        }
        List in = Util.getFiles(new File(mcdir, "saves"));
        int i = 0;
        while (i < in.size()) {
            File f = (File)in.get(i);
            if (f.isDirectory()) {
                File dir = new File(destination, f.getName());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                Util.compressFiles(f, new File(dir, String.valueOf(f.getName()) + "." + System.currentTimeMillis() + ".zip"));
            } else {
                Util.compressFiles(f, new File(destination, String.valueOf(f.getName()) + "." + System.currentTimeMillis() + ".zip"));
            }
            ++i;
        }
        return null;
    }

    public void run() {
        this.signalDone(ThreadBackupWorlds.backupWorlds(this.mcdir));
    }
}

