/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.MultipleCommands;
import com.sijobe.spc.core.Constants;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.util.KeyListener;
import com.sijobe.spc.util.KeyboardHandler;
import com.sijobe.spc.util.Settings;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterInteger;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandManager;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Minecraft;
import com.sijobe.spc.wrapper.MinecraftServer;
import com.sijobe.spc.wrapper.Player;
import java.io.File;
import java.util.List;
import org.lwjgl.input.Keyboard;

public class Bind
extends MultipleCommands
implements KeyListener {
    private static Settings BINDINGS = new Settings(new File(Constants.MOD_DIR, "bindings.properties"));
    private static Bind INSTANCE = new Bind("");
    private static final Parameters BIND_PARAMS;
    private static final Parameters BINDID_PARAMS;
    private static final Parameters UNBIND_PARAMS;

    public Bind(String name) {
        super(name);
    }

    private void addKeyListeners() {
        for (Object key : BINDINGS.keySet()) {
            try {
                this.bind(Integer.parseInt((String)key));
            }
            catch (Exception e) {
                System.err.println("Invalid key specified in bindings: " + key);
                BINDINGS.remove(key);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return Minecraft.isSinglePlayer();
    }

    @Override
    public String[] getCommands() {
        return new String[]{"bind", "unbind", "bindid", "unbindid"};
    }

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        if (this.getName().equalsIgnoreCase("bind") || this.getName().equalsIgnoreCase("bindid")) {
            int keycode = 0;
            if (this.getName().equalsIgnoreCase("bind")) {
                String key = (String)params.get(0);
                keycode = Keyboard.getKeyIndex((String)key.toUpperCase());
            } else {
                keycode = (Integer)params.get(0);
            }
            if (keycode == 0) {
                throw new CommandException("Unknown keycode " + params.get(0));
            }
            String command = (String)params.get(1);
            String param = "";
            if (params.size() > 2) {
                param = (String)params.get(2);
            }
            if (BINDINGS.get(keycode + "") == null) {
                this.bind(keycode);
            }
            BINDINGS.set(keycode + "", command + " " + param);
            BINDINGS.save();
            sender.sendMessageToPlayer("Key " + (Object)((Object)FontColour.AQUA) + params.get(0) + (Object)((Object)FontColour.WHITE) + " was successfully bound.");
        } else if (this.getName().equalsIgnoreCase("unbind") || this.getName().equalsIgnoreCase("unbindid")) {
            int keycode = 0;
            if (this.getName().equalsIgnoreCase("unbind")) {
                String key = (String)params.get(0);
                if (key.equalsIgnoreCase("all")) {
                    BINDINGS.clear();
                    BINDINGS.save();
                    sender.sendMessageToPlayer("All bindings removed.");
                    return;
                }
                keycode = Keyboard.getKeyIndex((String)key.toUpperCase());
            } else {
                keycode = (Integer)params.get(0);
            }
            if (keycode == 0) {
                throw new CommandException("Unknown keycode " + params.get(0));
            }
            this.unbind(keycode);
            if (BINDINGS.remove(keycode + "") == null) {
                throw new CommandException("No binding was found for key " + (Object)((Object)FontColour.AQUA) + (String)params.get(0));
            }
            BINDINGS.save();
            sender.sendMessageToPlayer("Binding " + (Object)((Object)FontColour.AQUA) + params.get(0) + (Object)((Object)FontColour.WHITE) + " was successfully removed.");
        } else assert (false) : "Invalid command " + this.getName();
    }

    private void bind(int key) {
        if (!KeyboardHandler.getInstance().addKeyPressedListener(key, INSTANCE)) {
            System.err.println("Invalid key specified in bindings: " + key);
            BINDINGS.remove(key);
        }
    }

    private void unbind(int key) {
        KeyboardHandler.getInstance().removeKeyPressedListener(key, INSTANCE);
    }

    @Override
    public Parameters getParameters() {
        if (this.getName().equalsIgnoreCase("bind")) {
            return BIND_PARAMS;
        }
        if (this.getName().equalsIgnoreCase("unbind")) {
            return UNBIND_PARAMS;
        }
        if (this.getName().equalsIgnoreCase("bindid")) {
            return BINDID_PARAMS;
        }
        assert (false) : "Invalid command name initialsied " + this.getName();
        return Parameters.DEFAULT;
    }

    @Override
    public void keyPressed(int key) {
        if (Minecraft.isGuiScreenOpen()) {
            return;
        }
        Player player = Minecraft.getPlayer();
        if (player != null) {
            CommandSender sender = new CommandSender(MinecraftServer.getPlayerByUsername(player.getPlayerName()));
            CommandManager.runCommand(sender, BINDINGS.getString(key + "", ""));
        }
    }

    @Override
    public void keyReleased(int key) {
    }

    static {
        INSTANCE.addKeyListeners();
        BIND_PARAMS = new Parameters(new Parameter[]{new ParameterString("<KEYCODE>", false), new ParameterString("<COMMAND>", false), new ParameterString("{PARAMETERS}", true, true)});
        BINDID_PARAMS = new Parameters(new Parameter[]{new ParameterInteger("<KEYID>", false), new ParameterString("<COMMAND>", false), new ParameterString("{PARAMETERS}", true, true)});
        UNBIND_PARAMS = new Parameters(new Parameter[]{new ParameterString("<KEYCODE|all>", false)});
    }
}

