/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Player;
import java.util.List;

@Command(name="gamemode", description="Changes the gamemode", example="adventure", videoURL="http://www.youtube.com/watch?v=1pAkRcp3KaY", version="1.0", alias={"gm"})
public class Gamemode
extends StandardCommand {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("[creative|survival|adventure]", true, new String[]{"creative", "survival", "adventure", "0", "1", "2"})});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        Player player = StandardCommand.getSenderAsPlayer(sender);
        String value = null;
        if (params.size() != 0) {
            value = (String)params.get(0);
            try {
                int integer = Integer.parseInt(value);
                switch (integer) {
                    case 0: {
                        value = "survival";
                        break;
                    }
                    case 1: {
                        value = "creative";
                        break;
                    }
                    case 2: {
                        value = "adventure";
                        break;
                    }
                    default: {
                        throw new CommandException("Unknown gamemode type.");
                    }
                }
            }
            catch (Exception e) {}
        } else {
            value = player.isCreativeMode() ? "survival" : "creative";
        }
        if (!player.setGameType(value)) {
            throw new CommandException("Unknown gamemode type");
        }
        sender.sendMessageToPlayer("Gamemode changed to " + (Object)((Object)FontColour.AQUA) + value);
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

