/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterInteger;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Item;
import java.util.List;

@Command(name="give", description="Gives player item, if quantity isn\u2019t specified maximum amount of that item", example="wool:5 32", videoURL="http://www.youtube.com/watch?v=tPeyVQI8RMg", version="1.0", alias={"i", "item"})
public class Give
extends StandardCommand {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("<ITEMCODE|ITEMNAME>", false), new ParameterInteger("[QUANTITY]", true), new ParameterInteger("[DAMAGE]", true)});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        int damage = 0;
        String[] split = ((String)params.get(0)).split("(\\^|:)");
        if (split.length == 2) {
            try {
                damage = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                throw new CommandException("Could not parse damage value of " + split[1]);
            }
        }
        int code = -1;
        try {
            code = Integer.parseInt(split[0]);
        }
        catch (NumberFormatException e) {
            code = -1;
        }
        if (code <= 0) {
            code = Item.getItemId(split[0].replace('_', ' '));
        }
        if (!Item.isValidItem(code)) {
            throw new CommandException("Cannot find specified item: " + split[0]);
        }
        int quantity = params.size() > 1 ? (Integer)params.get(1) : 0;
        int n = damage = params.size() > 2 ? (Integer)params.get(2) : damage;
        if (quantity == 0) {
            StandardCommand.getSenderAsPlayer(sender).givePlayerItem(code);
        } else if (damage == 0) {
            StandardCommand.getSenderAsPlayer(sender).givePlayerItem(code, quantity);
        } else {
            StandardCommand.getSenderAsPlayer(sender).givePlayerItem(code, quantity, damage);
        }
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

