/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandManager;
import com.sijobe.spc.wrapper.CommandSender;
import java.util.Collections;
import java.util.List;

@Command(name="help", description="Brings up the help message", example="give", videoURL="http://www.youtube.com/watch?v=mxU4p_vvjGw", version="1.1", alias={"?"})
public class Help
extends StandardCommand {
    public static final String MESSAGE_HEADING = (Object)((Object)FontColour.GREEN) + "===Help===================";
    public static final String MESSAGE_FOOTER = (Object)((Object)FontColour.GREEN) + "==========================";
    public static final String MESSAGE_USAGE = (Object)((Object)FontColour.GREEN) + "Usage: " + (Object)((Object)FontColour.WHITE);
    public static final String MESSAGE_DESCRIPTION = (Object)((Object)FontColour.GREEN) + "Description: " + (Object)((Object)FontColour.WHITE);
    public static final String MESSAGE_EXAMPLE = (Object)((Object)FontColour.GREEN) + "Example: " + (Object)((Object)FontColour.WHITE);
    public static final String MESSAGE_VIDEO = (Object)((Object)FontColour.GREEN) + "Video: " + (Object)((Object)FontColour.WHITE);
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("[COMMAND_NAME]", true)});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        if (params.size() == 0) {
            List names = CommandManager.getCommandNames();
            Collections.sort(names);
            String commands = "";
            for (String name : names) {
                if (!CommandManager.isCommandEnabled(name) || !CommandManager.hasPermission(name, Help.getSenderAsPlayer(sender))) continue;
                if (name.startsWith("/")) {
                    commands = commands + "/" + name + ", ";
                    continue;
                }
                commands = commands + name + ", ";
            }
            if (commands.length() > 0) {
                commands = commands.substring(0, commands.length() - 2);
            }
            sender.sendMessageToPlayer(MESSAGE_HEADING);
            sender.sendMessageToPlayer(commands);
            sender.sendMessageToPlayer("Use " + (Object)((Object)FontColour.AQUA) + "/help COMMAND_NAME" + (Object)((Object)FontColour.WHITE) + " for more information.");
            sender.sendMessageToPlayer(MESSAGE_FOOTER);
        } else {
            String command = (String)params.get(0);
            if (!CommandManager.doesCommandExist(command) || !CommandManager.isCommandEnabled(command)) {
                throw new CommandException("Specified command name " + command + " does not exist or is not enabled.");
            }
            String description = CommandManager.getCommandDescription(command);
            String example = CommandManager.getCommandExample(command);
            String usage = CommandManager.getCommandUsage(command, sender);
            String video = CommandManager.getCommandVideo(command);
            sender.sendMessageToPlayer(MESSAGE_HEADING);
            sender.sendMessageToPlayer("Help for the " + (Object)((Object)FontColour.AQUA) + command + (Object)((Object)FontColour.WHITE) + " command.");
            if (description != null) {
                sender.sendMessageToPlayer(MESSAGE_DESCRIPTION + description);
            }
            if (usage != null) {
                sender.sendMessageToPlayer(MESSAGE_USAGE + usage);
            }
            if (example != null) {
                sender.sendMessageToPlayer(MESSAGE_EXAMPLE + "/" + command + " " + example);
            }
            if (video != null) {
                sender.sendMessageToPlayer(MESSAGE_VIDEO + video);
            }
            sender.sendMessageToPlayer(MESSAGE_FOOTER);
        }
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

