/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Player;
import java.util.List;

@Command(name="hunger", description="Sets the players hunger level to pre-defined figures", example="infinite", videoURL="http://www.youtube.com/watch?v=Ymc7JDgdtXU", version="1.0")
public class Hunger
extends StandardCommand {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("<empty|full|infinite>", false, new String[]{"empty", "full", "infinite"})});

    @Override
    public void execute(CommandSender sender, List params) {
        String action = (String)params.get(0);
        Player player = StandardCommand.getSenderAsPlayer(sender);
        if (action.equalsIgnoreCase("empty")) {
            player.setHunger(0);
        } else if (action.equalsIgnoreCase("full")) {
            player.setHunger(20);
        } else if (action.equalsIgnoreCase("infinite")) {
            player.setHunger(Short.MAX_VALUE);
        } else {
            if (action.equalsIgnoreCase("enable")) {
                player.sendChatMessage((Object)((Object)FontColour.ORANGE) + "Cannot enable/disable hunger");
                return;
            }
            if (action.equalsIgnoreCase("disable")) {
                player.sendChatMessage((Object)((Object)FontColour.ORANGE) + "Cannot enable/disable hunger");
                return;
            }
        }
        player.sendChatMessage("Your hunger level is set at " + (Object)((Object)FontColour.AQUA) + player.getHunger());
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

