/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.core.Constants;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandManager;
import com.sijobe.spc.wrapper.CommandSender;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;

@Command(name="macro", description="Macro based commands allow multiple commands to be run", example="test", videoURL="http://www.youtube.com/watch?v=hkQfslQJoQs", version="1.0")
public class Macro
extends StandardCommand {
    public static final String MACRO_EXTENSION = ".txt";
    public static final File MACRO_DIR = new File(Constants.MOD_DIR, "macros");
    private static final Parameters PARAMETERS;

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        File macro = new File(MACRO_DIR, (String)params.get(0) + MACRO_EXTENSION);
        if (!macro.exists()) {
            throw new CommandException("Specified macro does not exist.");
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(macro));
            String[] split = null;
            split = params.size() == 1 ? new String[]{(String)params.get(0)} : ((String)params.get(0) + " " + (String)params.get(1)).split(" ");
            String line = null;
            while ((line = br.readLine()) != null) {
                for (int i = 0; i < split.length; ++i) {
                    line = line.replaceAll("\\$_" + i, split[i]);
                }
                line = line.replaceAll("\\$_[0-9]+", "");
                CommandManager.runCommand(sender, line);
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }

    static {
        if (!MACRO_DIR.exists()) {
            MACRO_DIR.mkdirs();
        }
        PARAMETERS = new Parameters(new Parameter[]{new ParameterString("<FILE>", false), new ParameterString("{PARAMETERS}", true, true)});
    }
}

