/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterInteger;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Player;
import java.util.List;

@Command(name="setspawn", description="Sets the spawn point of the world the player is in", videoURL="http://www.youtube.com/watch?v=2ZTAiIPpL3U")
public class SetSpawn
extends StandardCommand {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterInteger("[X Y Z]", true), new ParameterInteger("", true), new ParameterInteger("", true)});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        if (params.size() != 0 && params.size() < 3) {
            throw new CommandException("Usage: " + this.getUsage(sender));
        }
        Player player = SetSpawn.getSenderAsPlayer(sender);
        if (params.size() == 0) {
            player.getWorld().setSpawn(player.getPosition());
        } else {
            player.getWorld().setSpawn(new Coordinate((Integer)params.get(0), (Integer)params.get(1), (Integer)params.get(2)));
        }
        Coordinate spawn = player.getWorld().getSpawn();
        player.sendChatMessage("Spawn point set to " + (Object)((Object)FontColour.AQUA) + spawn.getBlockX() + (Object)((Object)FontColour.WHITE) + "," + (Object)((Object)FontColour.AQUA) + spawn.getBlockY() + (Object)((Object)FontColour.WHITE) + "," + (Object)((Object)FontColour.AQUA) + spawn.getBlockZ());
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

