/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterInteger;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Entity;
import com.sijobe.spc.wrapper.Player;
import java.util.List;

@Command(name="spawn", description="", example="creeper 5", videoURL="http://www.youtube.com/watch?v=4R8z-NFUCkM", version="1.0")
public class Spawn
extends StandardCommand {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("<NAME|ID|random|list>", false), new ParameterInteger("[QUANTITY]", true)});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        Player player;
        Coordinate coord;
        String argument = (String)params.get(0);
        if (argument.equalsIgnoreCase("list")) {
            String list = "";
            for (String name : Entity.getNameToIdEntityList().keySet()) {
                list = list + name + " (" + Entity.getNameToIdEntityList().get(name) + "), ";
            }
            list = list.substring(0, list.length() - 2);
            sender.sendMessageToPlayer(list);
            return;
        }
        if (argument.equalsIgnoreCase("random")) {
            argument = (String)Entity.getLoadedEntities().get((int)(Math.random() * (double)Entity.getLoadedEntities().size()));
        }
        try {
            argument = Entity.getEntityName(Integer.parseInt(argument));
            if (argument == null) {
                throw new CommandException("Invalid ID specified " + params.get(0));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int quantity = 1;
        if (params.size() > 1) {
            quantity = (Integer)params.get(1);
        }
        if ((coord = (player = StandardCommand.getSenderAsPlayer(sender)).trace(128.0)) == null) {
            coord = player.getPosition();
            coord = new Coordinate(coord.getX() + Math.random() * 10.0 - 5.0, coord.getY(), coord.getZ() + Math.random() * 10.0 - 5.0);
        }
        for (int i = 0; i < quantity; ++i) {
            if (Entity.spawnEntity(argument, coord, player.getWorld())) continue;
            throw new CommandException("Could not spawn entity named " + argument);
        }
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

