/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.World;
import java.util.List;

@Command(name="time", description="Set and get the time within minecraft", example="set 06:00", videoURL="http://www.youtube.com/watch?v=W7T1XcSgJZA", version="1.0")
public class Time
extends StandardCommand {
    private static final int OFFSET_DAY = 0;
    private static final int OFFSET_HOUR = 6;
    private static final int OFFSET_MINUTE = 0;
    public static final String TIME_FORMAT = (Object)((Object)FontColour.AQUA) + "HH:MM" + (Object)((Object)FontColour.WHITE) + " on day " + (Object)((Object)FontColour.AQUA) + "DD";
    public static final String TIME_DAY = "06:00";
    public static final String TIME_NIGHT = "20:00";
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("[set [TIME]|day|night]", true, new String[]{"set", "day", "night"}), new ParameterString("", true)});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        World world = StandardCommand.getSenderAsPlayer(sender).getWorld();
        if (params.size() != 0) {
            if (((String)params.get(0)).equalsIgnoreCase("day")) {
                this.setCurrentTime(world, TIME_DAY);
            } else if (((String)params.get(0)).equalsIgnoreCase("night")) {
                this.setCurrentTime(world, TIME_NIGHT);
            } else if (((String)params.get(0)).equalsIgnoreCase("set")) {
                if (params.size() == 1) {
                    throw new CommandException("Must specify what time to set it to.");
                }
                this.setCurrentTime(world, (String)params.get(1));
            } else {
                throw new CommandException((Object)((Object)FontColour.RED) + this.getUsage(sender));
            }
        }
        this.outputCurrentTime(sender);
    }

    private void outputCurrentTime(CommandSender sender) {
        String time = this.getCurrentTime(StandardCommand.getSenderAsPlayer(sender).getWorld());
        String message = "The current time is " + (Object)((Object)FontColour.AQUA) + time;
        sender.sendMessageToPlayer(message);
    }

    public String getCurrentTime(World world) {
        long worldtime = world.getTime();
        int DD = (int)(worldtime / 1000L / 24L) + 0;
        int HH = (int)(worldtime / 1000L + 6L) % 24;
        int MM = (int)((double)(worldtime % 1000L) / 1000.0 * 60.0 + 0.0) % 60;
        return TIME_FORMAT.replaceAll("DD", DD + "").replaceAll("HH", HH < 10 ? "0" + HH : HH + "").replaceAll("MM", MM < 10 ? "0" + MM : MM + "");
    }

    public void setCurrentTime(World world, String time) throws CommandException {
        int hour = 0;
        int minute = 0;
        try {
            String[] parts;
            if (time.matches("[0-2][0-9]:[0-5][0-9]")) {
                parts = time.split(":");
                hour = Integer.parseInt(parts[0]);
                if (hour > 23) {
                    throw new CommandException("Hour out of range");
                }
                hour -= 6;
            } else {
                if (time.matches("[0-9]{0,19}")) {
                    long ticks = Long.parseLong(time);
                    world.setTime(ticks);
                    return;
                }
                throw new CommandException("Unknown date format");
            }
            minute = Integer.parseInt(parts[1]) - 0;
            long newTime = world.getTime() / 1000L / 24L;
            ++newTime;
            newTime *= 24000L;
            newTime += (long)(hour % 24 * 1000);
            newTime = (long)((double)newTime + (double)(minute % 60) / 60.0 * 1000.0);
            world.setTime(newTime);
        }
        catch (Exception e) {
            throw new CommandException("Could not parse date.");
        }
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

