/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.MultipleCommands;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.util.Settings;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Player;
import java.text.DecimalFormat;
import java.util.List;

public class Waypoint
extends MultipleCommands {
    public static final String PREFIX = "waypoint-";
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("<NAME>", false)});

    public Waypoint(String name) {
        super(name);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String[] getCommands() {
        return new String[]{"set", "rem", "goto"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        Player player = MultipleCommands.getSenderAsPlayer(sender);
        if (this.getName().equalsIgnoreCase("set")) {
            this.setWaypoint((String)params.get(0), player);
            player.sendChatMessage("Waypoint was set at " + (Object)((Object)FontColour.AQUA) + this.getLocationAsString(player.getPosition()));
        } else if (this.getName().equalsIgnoreCase("rem")) {
            if (!this.removeWaypoint((String)params.get(0), player)) throw new CommandException("Waypoint does not exist.");
            player.sendChatMessage("Waypoint was removed.");
        } else if (this.getName().equalsIgnoreCase("goto")) {
            if (!this.gotoWaypoint((String)params.get(0), player)) throw new CommandException("Waypoint does not exist.");
            player.sendChatMessage("Whoosh");
        } else assert (false) : "Unexpected call not being handled: " + params.get(0);
        MultipleCommands.loadSettings(player).save();
    }

    private String getLocationAsString(Coordinate c) {
        if (c == null) {
            return "N/A";
        }
        DecimalFormat twodd = new DecimalFormat("#.##");
        return twodd.format(c.getX()) + "," + twodd.format(c.getY()) + "," + twodd.format(c.getZ());
    }

    public void setWaypoint(String name, Player player) {
        if (name == null || player == null) {
            return;
        }
        Settings config = MultipleCommands.loadSettings(player);
        Coordinate position = player.getPosition();
        String value = position.getX() + "," + position.getY() + "," + position.getZ() + "," + player.getYaw() + "," + player.getPitch();
        config.set((PREFIX + name).toLowerCase(), value);
    }

    public boolean removeWaypoint(String name, Player player) {
        if (name == null || player == null) {
            return false;
        }
        Settings config = MultipleCommands.loadSettings(player);
        return config.remove((PREFIX + name).toLowerCase()) != null;
    }

    public boolean gotoWaypoint(String name, Player player) {
        if (name == null || player == null) {
            return false;
        }
        Settings config = MultipleCommands.loadSettings(player);
        String waypoint = config.getString((PREFIX + name).toLowerCase(), null);
        if (waypoint == null) {
            return false;
        }
        String[] parts = waypoint.split(",");
        if (parts.length != 5) {
            return false;
        }
        double x2 = Double.parseDouble(parts[0]);
        double y = Double.parseDouble(parts[1]);
        double z = Double.parseDouble(parts[2]);
        float yaw = Float.parseFloat(parts[3]);
        float pitch = Float.parseFloat(parts[4]);
        player.setPosition(new Coordinate(x2, y, z));
        player.setYaw(yaw);
        player.setPitch(pitch);
        return true;
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

