/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.core;

import com.sijobe.spc.util.DynamicClassLoader;
import com.sijobe.spc.wrapper.Minecraft;
import java.io.File;
import java.net.URL;

public class SPCLoader {
    private static boolean IS_LOADED = false;

    public static void load() {
        if (!IS_LOADED) {
            IS_LOADED = true;
            SPCLoader.loadClasspath();
            SPCLoader.populateClassLoader();
        }
    }

    private static void populateClassLoader() {
        String classname = SPCLoader.class.getName();
        int depth = classname.split("\\.").length;
        String location = SPCLoader.class.getResource((classname = classname.split("\\.")[depth - 1]) + ".class").toString();
        if (location.startsWith("jar")) {
            try {
                location = location.replaceAll("jar:", "").split("!")[0];
                File root = new File(new URL(location).toURI());
                DynamicClassLoader.loadClassesFromJAR(root);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                File root = new File(new URL(location).toURI());
                for (int i = 0; i < depth; ++i) {
                    root = root.getParentFile();
                }
                DynamicClassLoader.loadClassesFromDirectory(root);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadClasspath() {
        File[] files;
        File[] classpath = DynamicClassLoader.getClasspath();
        for (File file : files = new File(Minecraft.getMinecraftDirectory(), "bin").listFiles()) {
            try {
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                boolean found = false;
                for (File url : classpath) {
                    if (url == null || !url.equals(file)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                DynamicClassLoader.addFile(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

