/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.hooks;

import com.sijobe.spc.command.MultipleCommands;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.core.PlayerMP;
import com.sijobe.spc.core.SPCLoader;
import com.sijobe.spc.util.DynamicClassLoader;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.worldedit.WorldEditCommandSet;
import com.sijobe.spc.wrapper.CommandBase;
import com.sijobe.spc.wrapper.CommandManager;
import com.sijobe.spc.wrapper.Player;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class InitialiseCommands
extends PlayerMP {
    public static List WELCOME_FLAG = new ArrayList();
    private static boolean IS_LOADED = false;
    private static final String WELCOME_MESSAGE = (Object)((Object)FontColour.GREY) + "Single Player Commands (" + "4.8" + ") - " + (Object)((Object)FontColour.ORANGE) + "http://bit.ly/spcmod";

    public InitialiseCommands() {
        this.loadCommands();
    }

    @Override
    public void onTick(Player player) {
        if (IS_LOADED && !WELCOME_FLAG.contains(player.getPlayerName())) {
            this.sendStartupMessage(player);
            WELCOME_FLAG.add(player.getPlayerName());
        }
    }

    private void sendStartupMessage(Player player) {
        player.sendChatMessage(WELCOME_MESSAGE);
    }

    private void loadCommands() {
        new Thread(){

            @Override
            public void run() {
                SPCLoader.load();
                InitialiseCommands.this.loadMultipleCommands();
                if (WorldEditCommandSet.getCurrentInstance() == null) {
                    try {
                        Class.forName("com.sk89q.worldedit.WorldEdit");
                        System.out.println("SPCommands: Forcing command re-load.");
                        InitialiseCommands.this.loadMultipleCommands();
                    }
                    catch (Exception e) {
                        System.out.println("SPCommands: Leaving WorldEdit support unloaded.");
                    }
                }
                InitialiseCommands.this.loadStandardCommands();
                IS_LOADED = true;
            }
        }.start();
    }

    private void loadStandardCommands() {
        List commands = DynamicClassLoader.getClasses(StandardCommand.class);
        for (Class command : commands) {
            if (Modifier.isAbstract(command.getModifiers())) continue;
            try {
                StandardCommand cmd = (StandardCommand)((Object)command.newInstance());
                if (!cmd.isEnabled()) continue;
                if (InitialiseCommands.doesCommandExist(cmd)) {
                    System.out.println("Overwriting existing command named: " + cmd.getName());
                }
                CommandManager.registerCommand(cmd);
            }
            catch (Exception e) {
                System.err.println("There was an issue initialising class " + command.getName() + ". Verify that the class is setup correctly.");
                e.printStackTrace();
            }
        }
    }

    private void loadMultipleCommands() {
        List sets = DynamicClassLoader.getClasses(MultipleCommands.class);
        for (Class command : sets) {
            if (Modifier.isAbstract(command.getModifiers())) continue;
            try {
                Constructor constructor = command.getConstructor(String.class);
                MultipleCommands instance = (MultipleCommands)((Object)constructor.newInstance(new Object[]{null}));
                String[] commandNames = instance.getCommands();
                if (commandNames == null) continue;
                for (String name : commandNames) {
                    MultipleCommands cmd = (MultipleCommands)((Object)constructor.newInstance(name));
                    if (!cmd.isEnabled()) continue;
                    if (InitialiseCommands.doesCommandExist(cmd)) {
                        System.out.println("Overwriting existing command named: " + cmd.getName());
                    }
                    CommandManager.registerCommand(cmd);
                }
            }
            catch (Throwable e) {
                System.err.println("Failed to load " + command.getName());
                e.printStackTrace();
            }
        }
    }

    public static boolean doesCommandExist(CommandBase command) {
        if (CommandManager.doesCommandExist(command.c())) {
            return true;
        }
        if (command.getAliases() != null) {
            for (String alias : command.getAliases()) {
                if (!CommandManager.doesCommandExist(alias)) continue;
                return true;
            }
        }
        return false;
    }
}

