/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.util;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DynamicClassLoader {
    private static URLClassLoader CLASSLOADER;
    private static boolean POPULATED;

    public static URLClassLoader getClassLoader() {
        if (CLASSLOADER == null) {
            CLASSLOADER = (URLClassLoader)DynamicClassLoader.class.getClassLoader();
        }
        return CLASSLOADER;
    }

    public static boolean addFile(String file) {
        return DynamicClassLoader.addFile(new File(file));
    }

    public static boolean addFile(File file) {
        try {
            return DynamicClassLoader.addURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean addURL(URL file) {
        URLClassLoader sysloader = DynamicClassLoader.getClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, file);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getClasses(Class type) {
        Vector<Class> found = new Vector<Class>();
        try {
            Vector classes;
            Field field = ClassLoader.class.getDeclaredField("classes");
            field.setAccessible(true);
            Vector vector = classes = (Vector)field.get(DynamicClassLoader.getClassLoader());
            synchronized (vector) {
                for (int i = 0; i < classes.size(); ++i) {
                    Class c = (Class)classes.get(i);
                    if (!type.isAssignableFrom(c)) continue;
                    found.add(c);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return found;
    }

    @Deprecated
    public static boolean hasBeenPopulated() {
        return POPULATED;
    }

    @Deprecated
    public static void populateClassLoaderWithClasses() {
        File[] files;
        POPULATED = true;
        for (File f : files = DynamicClassLoader.getClasspath()) {
            if (f == null || !f.exists()) continue;
            System.out.println("Loading classes from... " + f.getAbsolutePath());
            if (f.getAbsolutePath().endsWith(".jar")) {
                DynamicClassLoader.loadClassesFromJAR(f);
                continue;
            }
            if (f.isDirectory()) {
                DynamicClassLoader.loadClassesFromDirectory(f);
                continue;
            }
            try {
                DynamicClassLoader.loadClass(f.getName(), null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static List loadClassesFromDirectory(File directory) {
        return DynamicClassLoader.loadClassesFromDirectory(directory, "");
    }

    public static List loadClassesFromDirectory(File directory, String parent) {
        Vector<Class> classes = new Vector<Class>();
        try {
            File[] files;
            for (File file : files = directory.listFiles()) {
                try {
                    if (file.isFile()) {
                        classes.add(DynamicClassLoader.loadClass(file.getName(), parent));
                        continue;
                    }
                    classes.addAll(DynamicClassLoader.loadClassesFromDirectory(file, parent + file.getName() + "/"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return classes;
    }

    public static List loadClassesFromJAR(File jar) {
        Vector<Class> classes = new Vector<Class>();
        try {
            JarFile jf = new JarFile(jar);
            Enumeration<JarEntry> em2 = jf.entries();
            while (em2.hasMoreElements()) {
                JarEntry je = em2.nextElement();
                try {
                    classes.add(DynamicClassLoader.loadClass(je.getName(), null));
                }
                catch (Throwable t2) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return classes;
    }

    public static Class loadClass(String clazz, String pack) throws Exception {
        Class<?> c;
        if (!clazz.endsWith(".class")) {
            throw new Exception("'" + clazz + "' is not a class.");
        }
        clazz = clazz.split("\\.")[0];
        if (pack != null) {
            pack = pack.endsWith("/") ? pack.substring(0, pack.length() - 1) : pack;
        }
        clazz = pack == null ? clazz : pack + "." + clazz;
        clazz = clazz.replaceAll("/", ".");
        URLClassLoader loader = DynamicClassLoader.getClassLoader();
        try {
            c = loader.loadClass(clazz);
        }
        catch (Throwable e) {
            return null;
        }
        return c;
    }

    public static File[] getClasspath() {
        URLClassLoader urlLoader = DynamicClassLoader.getClassLoader();
        URL[] urls = urlLoader.getURLs();
        File[] classpath = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            try {
                classpath[i] = new File(urls[i].toURI());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return classpath;
    }

    static {
        POPULATED = false;
    }
}

