/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.validation;

import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ValidationException;
import java.util.ArrayList;
import java.util.List;

public class ParameterString
extends Parameter {
    private List validValues;
    private String expected;

    public ParameterString(String label, boolean optional) {
        this(label, optional, false, null);
    }

    public ParameterString(String label, boolean optional, boolean variableLength) {
        this(label, optional, variableLength, null);
    }

    public ParameterString(String label, boolean optional, String[] validValues) {
        super(label, optional, false);
        ArrayList<String> values = new ArrayList<String>();
        for (String value : validValues) {
            values.add(value);
        }
        this.initialise(label, optional, false, values);
    }

    public ParameterString(String label, boolean optional, List validValues) {
        this(label, optional, false, validValues);
    }

    public ParameterString(String label, boolean optional, boolean variableLength, List validValues) {
        super(label, optional, variableLength);
        this.initialise(label, optional, variableLength, validValues);
    }

    private void initialise(String label, boolean optional, boolean variableLength, List validValues) {
        this.validValues = validValues;
        if (validValues == null) {
            validValues = new ArrayList<String>();
        }
        for (int i = 0; i < validValues.size(); ++i) {
            validValues.set(i, ((String)validValues.get(i)).toLowerCase());
            this.expected = i == 0 ? (String)validValues.get(i) : this.expected + ", " + (String)validValues.get(i);
        }
    }

    @Override
    public Object validate(String parameter) throws ValidationException {
        if (this.validValues == null) {
            return parameter;
        }
        if (this.validValues.contains(parameter.toLowerCase())) {
            return parameter;
        }
        throw new ValidationException("Parameter " + parameter + " is an unexpected value (" + this.expected + ")");
    }
}

