/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.validation;

import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterBoolean;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.ValidationException;
import java.util.ArrayList;
import java.util.List;

public class Parameters {
    public static final Parameters DEFAULT = new Parameters(new Parameter[]{new ParameterString("", true, true)});
    public static final Parameters DEFAULT_BOOLEAN = new Parameters(new Parameter[]{new ParameterBoolean("[enable|disable]", true, "enable", "disable")});
    private Parameter[] params;

    public Parameters(Parameter[] params) {
        this.params = params;
    }

    public List validate(String[] parameters) throws ValidationException {
        ArrayList<Object> validated = new ArrayList<Object>();
        for (int i = 0; i < this.params.length; ++i) {
            if (i + 1 > parameters.length) {
                if (this.params[i].isOptional()) continue;
                throw new ValidationException("Not enough arguments");
            }
            try {
                if (i == this.params.length - 1 && parameters.length > this.params.length && this.params[i].isVariableLength()) {
                    String variableLength = "";
                    for (int j = i; j < parameters.length; ++j) {
                        variableLength = j == i ? parameters[j] : variableLength + " " + parameters[j];
                    }
                    validated.add(this.params[i].validate(variableLength));
                    continue;
                }
                validated.add(this.params[i].validate(parameters[i]));
                continue;
            }
            catch (ValidationException v) {
                throw v;
            }
            catch (Exception e) {
                throw new ValidationException("Problem with the command: " + e);
            }
        }
        return validated;
    }

    public String getUsage() {
        String usage = "";
        for (Parameter param : this.params) {
            usage = usage + param.getLabel() + " ";
        }
        return usage.trim();
    }
}

