/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.worldedit;

import com.sijobe.spc.command.MultipleCommands;
import com.sijobe.spc.worldedit.LocalPlayer;
import com.sijobe.spc.worldedit.PropertiesConfiguration;
import com.sijobe.spc.worldedit.ServerInterface;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.MinecraftServer;
import com.sijobe.spc.wrapper.Player;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldVector;
import java.util.List;

public class WorldEditCommandSet
extends MultipleCommands {
    public static WorldEdit WORLDEDIT;
    public static ServerInterface SERVER;
    public static PropertiesConfiguration CONFIGURATION;
    private static WorldEditCommandSet INSTANCE;
    private long leftClick;
    private long rightClick;
    private long leftBlock;
    private long rightBlock;
    private static final int CLICK_DELAY = 200;

    public WorldEditCommandSet(String name) {
        super(name);
        CONFIGURATION = new PropertiesConfiguration();
        CONFIGURATION.load();
        SERVER = new ServerInterface();
        WORLDEDIT = new WorldEdit((com.sk89q.worldedit.ServerInterface)SERVER, (LocalConfiguration)CONFIGURATION);
        this.leftBlock = this.rightBlock = System.currentTimeMillis();
        this.rightClick = this.rightBlock;
        this.leftClick = this.rightBlock;
        INSTANCE = this;
    }

    public static WorldEditCommandSet getCurrentInstance() {
        return INSTANCE;
    }

    @Override
    public String[] getCommands() {
        return WORLDEDIT.getCommands().keySet().toArray(new String[0]);
    }

    @Override
    public String getDescription() {
        return (String)WORLDEDIT.getCommands().get(this.getName());
    }

    @Override
    public void execute(CommandSender sender, List params) {
        String[] command = null;
        if (params.size() == 1) {
            String[] split = ((String)params.get(0)).split(" ");
            command = new String[split.length + 1];
            for (int i = 1; i < command.length; ++i) {
                command[i] = split[i - 1];
            }
            command[0] = "/" + this.getName();
        } else {
            command = new String[]{"/" + this.getName()};
        }
        this.handleCommand(WorldEditCommandSet.getSenderAsPlayer(sender), command);
    }

    public void handleCommand(Player player, String[] command) {
        WORLDEDIT.handleCommand((com.sk89q.worldedit.LocalPlayer)new LocalPlayer(player, SERVER), command);
    }

    public void handleArmSwing(Player player) {
        if (this.leftClick + 200L < System.currentTimeMillis()) {
            WORLDEDIT.handleArmSwing((com.sk89q.worldedit.LocalPlayer)new LocalPlayer(MinecraftServer.getPlayerByUsername(player.getPlayerName()), SERVER));
            this.leftClick = System.currentTimeMillis();
        }
    }

    public void handleRightClick(Player player) {
        if (this.rightClick + 200L < System.currentTimeMillis()) {
            WORLDEDIT.handleRightClick((com.sk89q.worldedit.LocalPlayer)new LocalPlayer(MinecraftServer.getPlayerByUsername(player.getPlayerName()), SERVER));
            this.rightClick = System.currentTimeMillis();
        }
    }

    public void handleBlockLeftClick(Player player, Coordinate block) {
        if (this.leftBlock + 200L < System.currentTimeMillis()) {
            LocalPlayer local = new LocalPlayer(MinecraftServer.getPlayerByUsername(player.getPlayerName()), SERVER);
            WorldVector vector = new WorldVector(local.getWorld(), block.getBlockX(), block.getBlockY(), block.getBlockZ());
            WORLDEDIT.handleBlockLeftClick((com.sk89q.worldedit.LocalPlayer)local, vector);
            this.leftBlock = System.currentTimeMillis();
        }
    }

    public void handleBlockRightClick(Player player, Coordinate block) {
        if (this.rightBlock + 200L < System.currentTimeMillis()) {
            LocalPlayer local = new LocalPlayer(MinecraftServer.getPlayerByUsername(player.getPlayerName()), SERVER);
            WorldVector vector = new WorldVector(local.getWorld(), block.getBlockX(), block.getBlockY(), block.getBlockZ());
            WORLDEDIT.handleBlockRightClick((com.sk89q.worldedit.LocalPlayer)local, vector);
            this.rightBlock = System.currentTimeMillis();
        }
    }
}

